/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.customfield.dao;

import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.ObjectType;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.customfield.CustomField;
import org.killbill.billing.util.dao.TableName;
import org.killbill.billing.util.entity.dao.EntityModelDao;
import org.killbill.billing.util.entity.dao.EntityModelDaoBase;

public class CustomFieldModelDao
extends EntityModelDaoBase
implements EntityModelDao<CustomField> {
    private String fieldName;
    private String fieldValue;
    private UUID objectId;
    private ObjectType objectType;
    private Boolean isActive;

    public CustomFieldModelDao() {
    }

    public CustomFieldModelDao(UUID id, DateTime createdDate, DateTime updatedDate, String fieldName, String fieldValue, UUID objectId, ObjectType objectType) {
        super(id, createdDate, updatedDate);
        this.fieldName = fieldName;
        this.fieldValue = fieldValue;
        this.objectId = objectId;
        this.objectType = objectType;
        this.isActive = true;
    }

    public CustomFieldModelDao(DateTime createdDate, String fieldName, String fieldValue, UUID objectId, ObjectType objectType) {
        this(UUIDs.randomUUID(), createdDate, createdDate, fieldName, fieldValue, objectId, objectType);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    public UUID getObjectId() {
        return this.objectId;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setFieldValue(String fieldValue) {
        this.fieldValue = fieldValue;
    }

    public void setObjectId(UUID objectId) {
        this.objectId = objectId;
    }

    public void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CustomFieldModelDao");
        sb.append("{fieldName='").append(this.fieldName).append('\'');
        sb.append(", fieldValue='").append(this.fieldValue).append('\'');
        sb.append(", objectId=").append(this.objectId);
        sb.append(", objectType=").append(this.objectType);
        sb.append(", isActive=").append(this.isActive);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomFieldModelDao that = (CustomFieldModelDao)o;
        if (this.fieldName != null ? !this.fieldName.equals(that.fieldName) : that.fieldName != null) {
            return false;
        }
        if (this.fieldValue != null ? !this.fieldValue.equals(that.fieldValue) : that.fieldValue != null) {
            return false;
        }
        if (this.objectId != null ? !this.objectId.equals(that.objectId) : that.objectId != null) {
            return false;
        }
        if (this.objectType != that.objectType) {
            return false;
        }
        return !(this.isActive != null ? !this.isActive.equals(that.isActive) : that.isActive != null);
    }

    public boolean isSame(CustomFieldModelDao that) {
        if (this.fieldName != null ? !this.fieldName.equals(that.fieldName) : that.fieldName != null) {
            return false;
        }
        if (this.fieldValue != null ? !this.fieldValue.equals(that.fieldValue) : that.fieldValue != null) {
            return false;
        }
        if (this.objectId != null ? !this.objectId.equals(that.objectId) : that.objectId != null) {
            return false;
        }
        if (this.objectType != that.objectType) {
            return false;
        }
        return !(this.isActive != null ? !this.isActive.equals(that.isActive) : that.isActive != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
        result = 31 * result + (this.fieldValue != null ? this.fieldValue.hashCode() : 0);
        result = 31 * result + (this.objectId != null ? this.objectId.hashCode() : 0);
        result = 31 * result + (this.objectType != null ? this.objectType.hashCode() : 0);
        result = 31 * result + (this.isActive != null ? this.isActive.hashCode() : 0);
        return result;
    }

    @Override
    public TableName getTableName() {
        return TableName.CUSTOM_FIELD;
    }

    @Override
    public TableName getHistoryTableName() {
        return TableName.CUSTOM_FIELD_HISTORY;
    }
}

