/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.customfield.dao;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.killbill.billing.BillingExceptionBase;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.events.BusEventBase;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.audit.AuditLogWithHistory;
import org.killbill.billing.util.audit.ChangeType;
import org.killbill.billing.util.audit.dao.AuditDao;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.customfield.CustomField;
import org.killbill.billing.util.customfield.api.DefaultCustomFieldCreationEvent;
import org.killbill.billing.util.customfield.api.DefaultCustomFieldDeletionEvent;
import org.killbill.billing.util.customfield.dao.CustomFieldDao;
import org.killbill.billing.util.customfield.dao.CustomFieldModelDao;
import org.killbill.billing.util.customfield.dao.CustomFieldSqlDao;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.dao.TableName;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.entity.dao.DefaultPaginationSqlDaoHelper;
import org.killbill.billing.util.entity.dao.EntityDaoBase;
import org.killbill.billing.util.entity.dao.EntitySqlDao;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionalJdbiWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoWrapperFactory;
import org.killbill.bus.api.BusEvent;
import org.killbill.bus.api.PersistentBus;
import org.killbill.clock.Clock;
import org.skife.jdbi.v2.IDBI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCustomFieldDao
extends EntityDaoBase<CustomFieldModelDao, CustomField, CustomFieldApiException>
implements CustomFieldDao {
    private static final Logger log = LoggerFactory.getLogger(DefaultCustomFieldDao.class);
    private final PersistentBus bus;
    private final AuditDao auditDao;

    @Inject
    public DefaultCustomFieldDao(IDBI dbi, @Named(value="main-ro") IDBI roDbi, Clock clock, CacheControllerDispatcher controllerDispatcher, NonEntityDao nonEntityDao, InternalCallContextFactory internalCallContextFactory, PersistentBus bus, AuditDao auditDao) {
        super(nonEntityDao, controllerDispatcher, new EntitySqlDaoTransactionalJdbiWrapper(dbi, roDbi, clock, controllerDispatcher, nonEntityDao, internalCallContextFactory), CustomFieldSqlDao.class);
        this.bus = bus;
        this.auditDao = auditDao;
    }

    @Override
    public List<CustomFieldModelDao> getCustomFieldsForObject(final UUID objectId, final ObjectType objectType, final InternalTenantContext context) {
        return this.transactionalSqlDao.execute(true, new EntitySqlDaoTransactionWrapper<List<CustomFieldModelDao>>(){

            @Override
            public List<CustomFieldModelDao> inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                return entitySqlDaoWrapperFactory.become(CustomFieldSqlDao.class).getCustomFieldsForObject(objectId, objectType, context);
            }
        });
    }

    @Override
    public List<CustomFieldModelDao> getCustomFieldsForAccountType(final ObjectType objectType, InternalTenantContext context) {
        List<CustomFieldModelDao> allFields = this.getCustomFieldsForAccount(context);
        return ImmutableList.copyOf((Collection)Collections2.filter(allFields, (Predicate)new Predicate<CustomFieldModelDao>(){

            public boolean apply(@Nullable CustomFieldModelDao input) {
                return input.getObjectType() == objectType;
            }
        }));
    }

    @Override
    public List<CustomFieldModelDao> getCustomFieldsForAccount(final InternalTenantContext context) {
        return this.transactionalSqlDao.execute(true, new EntitySqlDaoTransactionWrapper<List<CustomFieldModelDao>>(){

            @Override
            public List<CustomFieldModelDao> inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                return entitySqlDaoWrapperFactory.become(CustomFieldSqlDao.class).getByAccountRecordId(context);
            }
        });
    }

    @Override
    public void deleteCustomFields(final Iterable<UUID> customFieldIds, final InternalCallContext context) throws CustomFieldApiException {
        this.transactionalSqlDao.execute(false, new EntitySqlDaoTransactionWrapper<Void>(){

            @Override
            public Void inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                CustomFieldSqlDao sqlDao = entitySqlDaoWrapperFactory.become(CustomFieldSqlDao.class);
                for (UUID cur : customFieldIds) {
                    CustomFieldModelDao customField = (CustomFieldModelDao)sqlDao.getById(cur.toString(), (InternalTenantContext)context);
                    if (customField == null) continue;
                    sqlDao.markTagAsDeleted(cur.toString(), context);
                    DefaultCustomFieldDao.this.postBusEventFromTransaction(customField, customField, ChangeType.DELETE, entitySqlDaoWrapperFactory, context);
                }
                return null;
            }
        });
    }

    @Override
    public void updateCustomFields(final Iterable<CustomFieldModelDao> customFieldIds, final InternalCallContext context) throws CustomFieldApiException {
        this.transactionalSqlDao.execute(false, CustomFieldApiException.class, new EntitySqlDaoTransactionWrapper<Void>(){

            private void validateCustomField(CustomFieldModelDao input, @Nullable CustomFieldModelDao existing) throws CustomFieldApiException {
                if (existing == null) {
                    throw new CustomFieldApiException(ErrorCode.CUSTOM_FIELD_DOES_NOT_EXISTS_FOR_ID, new Object[]{input.getId()});
                }
                if (input.getObjectId() != null & !input.getObjectId().equals(existing.getObjectId())) {
                    throw new CustomFieldApiException(ErrorCode.CUSTOM_FIELD_INVALID_UPDATE, new Object[]{input.getId(), input.getObjectId(), "ObjectId"});
                }
                if (input.getObjectType() != null && input.getObjectType() != existing.getObjectType()) {
                    throw new CustomFieldApiException(ErrorCode.CUSTOM_FIELD_INVALID_UPDATE, new Object[]{input.getId(), input.getObjectType(), "ObjectType"});
                }
                if (input.getFieldName() != null && !input.getFieldName().equals(existing.getFieldName())) {
                    throw new CustomFieldApiException(ErrorCode.CUSTOM_FIELD_INVALID_UPDATE, new Object[]{input.getId(), input.getFieldName(), "FieldName"});
                }
            }

            @Override
            public Void inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                CustomFieldSqlDao sqlDao = entitySqlDaoWrapperFactory.become(CustomFieldSqlDao.class);
                for (CustomFieldModelDao cur : customFieldIds) {
                    CustomFieldModelDao customField = (CustomFieldModelDao)sqlDao.getById(cur.getId().toString(), (InternalTenantContext)context);
                    this.validateCustomField(cur, customField);
                    sqlDao.updateValue(cur.getId().toString(), cur.getFieldValue(), context);
                    DefaultCustomFieldDao.this.postBusEventFromTransaction(customField, customField, ChangeType.UPDATE, entitySqlDaoWrapperFactory, context);
                }
                return null;
            }
        });
    }

    @Override
    public List<AuditLogWithHistory> getCustomFieldAuditLogsWithHistoryForId(final UUID customFieldId, final AuditLevel auditLevel, final InternalTenantContext context) {
        return this.transactionalSqlDao.execute(true, new EntitySqlDaoTransactionWrapper<List<AuditLogWithHistory>>(){

            @Override
            public List<AuditLogWithHistory> inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) {
                CustomFieldSqlDao transactional = entitySqlDaoWrapperFactory.become(CustomFieldSqlDao.class);
                return DefaultCustomFieldDao.this.auditDao.getAuditLogsWithHistoryForId(transactional, TableName.CUSTOM_FIELD, customFieldId, auditLevel, context);
            }
        });
    }

    @Override
    protected CustomFieldApiException generateAlreadyExistsException(CustomFieldModelDao entity, InternalCallContext context) {
        return new CustomFieldApiException(ErrorCode.CUSTOM_FIELD_ALREADY_EXISTS, new Object[]{entity.getId()});
    }

    @Override
    protected boolean checkEntityAlreadyExists(EntitySqlDao<CustomFieldModelDao, CustomField> transactional, final CustomFieldModelDao entity, InternalCallContext context) {
        return Iterables.find(transactional.getByAccountRecordId((InternalTenantContext)context), (Predicate)new Predicate<CustomFieldModelDao>(){

            public boolean apply(CustomFieldModelDao existingCustomField) {
                return entity.isSame(existingCustomField);
            }
        }, null) != null;
    }

    @Override
    protected void postBusEventFromTransaction(CustomFieldModelDao customField, CustomFieldModelDao savedCustomField, ChangeType changeType, EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory, InternalCallContext context) throws BillingExceptionBase {
        BusEventBase customFieldEvent = null;
        switch (changeType) {
            case INSERT: {
                customFieldEvent = new DefaultCustomFieldCreationEvent(customField.getId(), customField.getObjectId(), customField.getObjectType(), context.getAccountRecordId(), context.getTenantRecordId(), context.getUserToken());
                break;
            }
            case DELETE: {
                customFieldEvent = new DefaultCustomFieldDeletionEvent(customField.getId(), customField.getObjectId(), customField.getObjectType(), context.getAccountRecordId(), context.getTenantRecordId(), context.getUserToken());
                break;
            }
            default: {
                return;
            }
        }
        try {
            this.bus.postFromTransaction((BusEvent)customFieldEvent, entitySqlDaoWrapperFactory.getHandle().getConnection());
        }
        catch (PersistentBus.EventBusException e) {
            log.warn("Failed to post tag event for customFieldId='{}'", (Object)customField.getId().toString(), (Object)e);
        }
    }

    @Override
    public Pagination<CustomFieldModelDao> searchCustomFields(final String searchKey, Long offset, Long limit, InternalTenantContext context) {
        return this.paginationHelper.getPagination(CustomFieldSqlDao.class, new DefaultPaginationSqlDaoHelper.PaginationIteratorBuilder<CustomFieldModelDao, CustomField, CustomFieldSqlDao>(){

            @Override
            public Long getCount(CustomFieldSqlDao customFieldSqlDao, InternalTenantContext context) {
                return customFieldSqlDao.getSearchCount(searchKey, String.format("%%%s%%", searchKey), context);
            }

            @Override
            public Iterator<CustomFieldModelDao> build(CustomFieldSqlDao customFieldSqlDao, Long offset, Long limit, DefaultPaginationSqlDaoHelper.Ordering ordering, InternalTenantContext context) {
                return customFieldSqlDao.search(searchKey, String.format("%%%s%%", searchKey), offset, limit, ordering.toString(), context);
            }
        }, offset, limit, context);
    }

    @Override
    public Pagination<CustomFieldModelDao> searchCustomFields(final String fieldName, final ObjectType objectType, Long offset, Long limit, InternalTenantContext context) {
        return this.paginationHelper.getPagination(CustomFieldSqlDao.class, new DefaultPaginationSqlDaoHelper.PaginationIteratorBuilder<CustomFieldModelDao, CustomField, CustomFieldSqlDao>(){

            @Override
            public Long getCount(CustomFieldSqlDao customFieldSqlDao, InternalTenantContext context) {
                return customFieldSqlDao.getSearchCountByObjectTypeAndFieldName(fieldName, objectType, context);
            }

            @Override
            public Iterator<CustomFieldModelDao> build(CustomFieldSqlDao customFieldSqlDao, Long offset, Long limit, DefaultPaginationSqlDaoHelper.Ordering ordering, InternalTenantContext context) {
                return customFieldSqlDao.searchByObjectTypeAndFieldName(fieldName, objectType, offset, limit, ordering.toString(), context);
            }
        }, offset, limit, context);
    }

    @Override
    public Pagination<CustomFieldModelDao> searchCustomFields(final String fieldName, final @Nullable String fieldValue, final ObjectType objectType, Long offset, Long limit, InternalTenantContext context) {
        return this.paginationHelper.getPagination(CustomFieldSqlDao.class, new DefaultPaginationSqlDaoHelper.PaginationIteratorBuilder<CustomFieldModelDao, CustomField, CustomFieldSqlDao>(){

            @Override
            public Long getCount(CustomFieldSqlDao customFieldSqlDao, InternalTenantContext context) {
                return customFieldSqlDao.getSearchCountByObjectTypeAndFieldNameValue(fieldName, fieldValue, objectType, context);
            }

            @Override
            public Iterator<CustomFieldModelDao> build(CustomFieldSqlDao customFieldSqlDao, Long offset, Long limit, DefaultPaginationSqlDaoHelper.Ordering ordering, InternalTenantContext context) {
                return customFieldSqlDao.searchByObjectTypeAndFieldNameValue(fieldName, fieldValue, objectType, offset, limit, ordering.toString(), context);
            }
        }, offset, limit, context);
    }
}

