/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.dao;

import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.audit.ChangeType;
import org.killbill.billing.util.dao.TableName;
import org.killbill.billing.util.entity.dao.EntityModelDaoBase;

public class EntityAudit
extends EntityModelDaoBase {
    private final TableName tableName;
    private final Long targetRecordId;
    private final ChangeType changeType;

    public EntityAudit(UUID entityId, TableName tableName, Long targetRecordId, ChangeType changeType, DateTime createdDate) {
        super(entityId, createdDate, null);
        this.tableName = tableName;
        this.targetRecordId = targetRecordId;
        this.changeType = changeType;
    }

    public EntityAudit(TableName tableName, Long targetRecordId, ChangeType changeType, DateTime createdDate) {
        this(UUIDs.randomUUID(), tableName, targetRecordId, changeType, createdDate);
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public Long getTargetRecordId() {
        return this.targetRecordId;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    @Override
    public String toString() {
        return "EntityAudit{tableName=" + (Object)((Object)this.tableName) + ", targetRecordId=" + this.targetRecordId + ", changeType=" + this.changeType + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EntityAudit that = (EntityAudit)((Object)o);
        if (this.changeType != that.changeType) {
            return false;
        }
        if (this.tableName != that.tableName) {
            return false;
        }
        return !(this.targetRecordId != null ? !this.targetRecordId.equals(that.targetRecordId) : that.targetRecordId != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
        result = 31 * result + (this.targetRecordId != null ? this.targetRecordId.hashCode() : 0);
        result = 31 * result + (this.changeType != null ? this.changeType.hashCode() : 0);
        return result;
    }
}

