/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.dao;

import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.entity.EntityBase;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.audit.ChangeType;
import org.killbill.billing.util.entity.Entity;
import org.killbill.billing.util.entity.dao.EntityModelDao;

public class EntityHistoryModelDao<M extends EntityModelDao<E>, E extends Entity>
extends EntityBase {
    private Long targetRecordId;
    private M entity;
    private ChangeType changeType;
    private Long historyRecordId;

    public EntityHistoryModelDao(UUID id, M src, Long targetRecordId, ChangeType type, Long historyRecordId, DateTime createdDate) {
        super(id, createdDate, createdDate);
        this.changeType = type;
        this.targetRecordId = targetRecordId;
        this.entity = src;
        this.historyRecordId = historyRecordId;
    }

    public EntityHistoryModelDao(M src, Long targetRecordId, ChangeType type, Long historyRecordId, DateTime createdDate) {
        this(UUIDs.randomUUID(), src, targetRecordId, type, historyRecordId, createdDate);
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public M getEntity() {
        return this.entity;
    }

    public Long getTargetRecordId() {
        return this.targetRecordId;
    }

    public void setTargetRecordId(Long targetRecordId) {
        this.targetRecordId = targetRecordId;
    }

    public void setEntity(M entity) {
        this.entity = entity;
    }

    public void setChangeType(ChangeType changeType) {
        this.changeType = changeType;
    }

    public Long getHistoryRecordId() {
        return this.historyRecordId;
    }

    public void setHistoryRecordId(Long historyRecordId) {
        this.historyRecordId = historyRecordId;
    }
}

