/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.entity.dao;

import com.google.common.annotations.VisibleForTesting;
import org.killbill.commons.profiling.Profiling;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.TransactionCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBRouterUntyped {
    private static final Logger logger = LoggerFactory.getLogger(DBRouterUntyped.class);
    private static final ThreadLocal<THREAD_STATE> CURRENT_THREAD_STATE = new ThreadLocal<THREAD_STATE>(){

        @Override
        public THREAD_STATE initialValue() {
            return THREAD_STATE.RW_ONLY;
        }
    };
    protected final IDBI dbi;
    protected final IDBI roDbi;

    public DBRouterUntyped(IDBI dbi, IDBI roDbi) {
        this.dbi = dbi;
        this.roDbi = roDbi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object withRODBIAllowed(boolean allowRODBI, Profiling.WithProfilingCallback<Object, Throwable> callback) throws Throwable {
        THREAD_STATE currentState = DBRouterUntyped.getCurrentState();
        CURRENT_THREAD_STATE.set(allowRODBI ? THREAD_STATE.RO_ALLOWED : THREAD_STATE.RW_ONLY);
        try {
            Object object = callback.execute();
            return object;
        }
        finally {
            CURRENT_THREAD_STATE.set(currentState);
        }
    }

    @VisibleForTesting
    public static THREAD_STATE getCurrentState() {
        return CURRENT_THREAD_STATE.get();
    }

    boolean shouldUseRODBI(boolean requestedRO) {
        if (requestedRO) {
            if (this.isRODBIAllowed()) {
                logger.debug("Using RO DBI");
                return true;
            }
            logger.debug("RO DBI requested, but thread state is {}, using RW DBI", (Object)DBRouterUntyped.getCurrentState());
            return false;
        }
        this.disallowRODBI();
        logger.debug("Using RW DBI");
        return false;
    }

    private boolean isRODBIAllowed() {
        return DBRouterUntyped.getCurrentState() == THREAD_STATE.RO_ALLOWED;
    }

    private void disallowRODBI() {
        CURRENT_THREAD_STATE.set(THREAD_STATE.RW_ONLY);
    }

    public Handle getHandle(boolean requestedRO) {
        if (this.shouldUseRODBI(requestedRO)) {
            return this.roDbi.open();
        }
        return this.dbi.open();
    }

    public <T> T onDemand(boolean requestedRO, Class<T> sqlObjectType) {
        if (this.shouldUseRODBI(requestedRO)) {
            return (T)this.roDbi.onDemand(sqlObjectType);
        }
        return (T)this.dbi.onDemand(sqlObjectType);
    }

    public <T> T inTransaction(boolean requestedRO, TransactionCallback<T> callback) {
        if (this.shouldUseRODBI(requestedRO)) {
            return (T)this.roDbi.inTransaction(callback);
        }
        return (T)this.dbi.inTransaction(callback);
    }

    public static enum THREAD_STATE {
        RO_ALLOWED,
        RW_ONLY;

    }
}

