/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.entity.dao;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.LinkedList;
import org.killbill.billing.BillingExceptionBase;
import org.killbill.billing.util.customfield.ShouldntHappenException;
import org.killbill.billing.util.entity.DefaultPagination;
import org.killbill.billing.util.entity.Entity;
import org.killbill.billing.util.entity.Pagination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPaginationHelper {
    private static final Logger log = LoggerFactory.getLogger(DefaultPaginationHelper.class);

    public static <E extends Entity, T extends BillingExceptionBase> Pagination<E> getEntityPaginationFromPlugins(boolean maxStatsCrossPlugins, Iterable<String> plugins, Long offset, Long limit, EntityPaginationBuilder<E, T> entityPaginationBuilder) {
        LinkedList allResults = new LinkedList();
        Long totalNbRecords = 0L;
        Long maxNbRecords = 0L;
        boolean firstSearch = true;
        for (String pluginName : plugins) {
            try {
                Pagination<E> pages;
                if ((long)allResults.size() >= limit) {
                    pages = entityPaginationBuilder.build(firstSearch ? offset : 0L, 1L, pluginName);
                    ImmutableList.copyOf(pages);
                } else {
                    pages = entityPaginationBuilder.build(firstSearch ? offset : 0L, limit - (long)allResults.size(), pluginName);
                    allResults.addAll(ImmutableList.copyOf(pages));
                }
                firstSearch = allResults.isEmpty();
                totalNbRecords = totalNbRecords + pages.getTotalNbRecords();
                if (!maxStatsCrossPlugins) {
                    maxNbRecords = maxNbRecords + pages.getMaxNbRecords();
                    continue;
                }
                maxNbRecords = Math.max(maxNbRecords, pages.getMaxNbRecords());
            }
            catch (BillingExceptionBase e) {
                log.warn("Error while searching plugin='{}'", (Object)pluginName, (Object)e);
            }
        }
        return new DefaultPagination(offset, limit, totalNbRecords, maxNbRecords, allResults.iterator());
    }

    public static <E extends Entity, O, T extends BillingExceptionBase> Pagination<E> getEntityPagination(Long limit, SourcePaginationBuilder<O, T> sourcePaginationBuilder, Function<O, E> function) throws T {
        Pagination<O> modelsDao = sourcePaginationBuilder.build();
        return new DefaultPagination((Pagination)modelsDao, limit, Iterators.filter((Iterator)Iterators.transform((Iterator)modelsDao.iterator(), function), (Predicate)Predicates.notNull()));
    }

    public static <E extends Entity, O, T extends BillingExceptionBase> Pagination<E> getEntityPaginationNoException(Long limit, SourcePaginationBuilder<O, T> sourcePaginationBuilder, Function<O, E> function) {
        try {
            return DefaultPaginationHelper.getEntityPagination(limit, sourcePaginationBuilder, function);
        }
        catch (BillingExceptionBase e) {
            throw new ShouldntHappenException("No exception expected" + (Object)((Object)e));
        }
    }

    public static abstract class SourcePaginationBuilder<O, T extends BillingExceptionBase> {
        public abstract Pagination<O> build() throws T;
    }

    public static abstract class EntityPaginationBuilder<E extends Entity, T extends BillingExceptionBase> {
        public abstract Pagination<E> build(Long var1, Long var2, String var3) throws T;
    }
}

