/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.entity.dao;

import com.google.common.annotations.VisibleForTesting;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.entity.DefaultPagination;
import org.killbill.billing.util.entity.Entity;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.entity.dao.EntityModelDao;
import org.killbill.billing.util.entity.dao.EntitySqlDao;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionalJdbiWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPaginationSqlDaoHelper {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPaginationSqlDaoHelper.class);
    private static final Long DEFAULT_SIMPLE_PAGINATION_THRESHOLD = 20000L;
    private final EntitySqlDaoTransactionalJdbiWrapper transactionalSqlDao;
    private final Long simplePaginationThreshold;

    public DefaultPaginationSqlDaoHelper(EntitySqlDaoTransactionalJdbiWrapper transactionalSqlDao) {
        this(transactionalSqlDao, DEFAULT_SIMPLE_PAGINATION_THRESHOLD);
    }

    @VisibleForTesting
    DefaultPaginationSqlDaoHelper(EntitySqlDaoTransactionalJdbiWrapper transactionalSqlDao, Long simplePaginationThreshold) {
        this.transactionalSqlDao = transactionalSqlDao;
        this.simplePaginationThreshold = simplePaginationThreshold;
    }

    public <E extends Entity, M extends EntityModelDao<E>, S extends EntitySqlDao<M, E>> Pagination<M> getPagination(final Class<? extends EntitySqlDao<M, E>> sqlDaoClazz, final PaginationIteratorBuilder<M, E, S> paginationIteratorBuilder, Long offset, Long limitMaybeNegative, final @Nullable InternalTenantContext context) {
        Long maxNbRecords;
        Ordering ordering = limitMaybeNegative >= 0L ? Ordering.ASC : Ordering.DESC;
        Long limit = Math.abs(limitMaybeNegative);
        Long totalNbRecordsOrNull = this.transactionalSqlDao.execute(true, new EntitySqlDaoTransactionWrapper<Long>(){

            @Override
            public Long inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                Object sqlDao = entitySqlDaoWrapperFactory.become(sqlDaoClazz);
                return paginationIteratorBuilder.getCount(sqlDao, context);
            }
        });
        EntitySqlDao<M, E> sqlDao = this.transactionalSqlDao.onDemandForStreamingResults(sqlDaoClazz);
        if (context == null) {
            maxNbRecords = null;
        } else {
            Long recordIdAtSimplePaginationOffset = sqlDao.getRecordIdAtOffset(this.simplePaginationThreshold);
            boolean veryLargeDataSet = recordIdAtSimplePaginationOffset != null;
            maxNbRecords = veryLargeDataSet ? null : sqlDao.getCount(context);
        }
        Iterator<M> results = paginationIteratorBuilder.build(sqlDao, offset, limit, ordering, context);
        Long totalNbRecords = totalNbRecordsOrNull == null ? maxNbRecords : totalNbRecordsOrNull;
        return new DefaultPagination<M>(offset, limit, totalNbRecords, maxNbRecords, results);
    }

    public static enum Ordering {
        ASC,
        DESC;

    }

    public static abstract class PaginationIteratorBuilder<M extends EntityModelDao<E>, E extends Entity, S extends EntitySqlDao<M, E>> {
        public abstract Long getCount(S var1, InternalTenantContext var2);

        public abstract Iterator<M> build(S var1, Long var2, Long var3, Ordering var4, InternalTenantContext var5);
    }
}

