/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.entity.dao;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.killbill.billing.BillingExceptionBase;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.audit.ChangeType;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheController;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.entity.DefaultPagination;
import org.killbill.billing.util.entity.Entity;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.entity.dao.DefaultPaginationSqlDaoHelper;
import org.killbill.billing.util.entity.dao.EntityDao;
import org.killbill.billing.util.entity.dao.EntityModelDao;
import org.killbill.billing.util.entity.dao.EntitySqlDao;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionalJdbiWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoWrapperFactory;

public abstract class EntityDaoBase<M extends EntityModelDao<E>, E extends Entity, U extends BillingExceptionBase>
implements EntityDao<M, E, U> {
    protected final EntitySqlDaoTransactionalJdbiWrapper transactionalSqlDao;
    protected final DefaultPaginationSqlDaoHelper paginationHelper;
    private final NonEntityDao nonEntityDao;
    private final CacheController<String, Long> recordIdCacheController;
    private final Class<? extends EntitySqlDao<M, E>> realSqlDao;
    private final Class<U> targetExceptionClass;

    public EntityDaoBase(NonEntityDao nonEntityDao, @Nullable CacheControllerDispatcher cacheControllerDispatcher, EntitySqlDaoTransactionalJdbiWrapper transactionalSqlDao, Class<? extends EntitySqlDao<M, E>> realSqlDao) {
        this.nonEntityDao = nonEntityDao;
        this.recordIdCacheController = cacheControllerDispatcher == null ? null : cacheControllerDispatcher.getCacheController(Cachable.CacheType.RECORD_ID);
        this.transactionalSqlDao = transactionalSqlDao;
        this.realSqlDao = realSqlDao;
        this.paginationHelper = new DefaultPaginationSqlDaoHelper(transactionalSqlDao);
        try {
            Type genericSuperclass = this.getClass().getGenericSuperclass();
            this.targetExceptionClass = genericSuperclass instanceof ParameterizedType ? Class.forName(((ParameterizedType)genericSuperclass).getActualTypeArguments()[2].getTypeName()) : null;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void create(M entity, InternalCallContext context) throws U {
        EntityModelDao refreshedEntity = (EntityModelDao)this.transactionalSqlDao.execute(false, this.targetExceptionClass, this.getCreateEntitySqlDaoTransactionWrapper(entity, context));
        this.transactionalSqlDao.populateCaches(refreshedEntity);
    }

    @Override
    public void create(Iterable<M> entities, InternalCallContext context) throws U {
        List refreshedEntities = (List)this.transactionalSqlDao.execute(false, this.targetExceptionClass, this.getCreateEntitySqlDaoTransactionWrapper((M)entities, context));
        for (EntityModelDao refreshedEntity : refreshedEntities) {
            this.transactionalSqlDao.populateCaches(refreshedEntity);
        }
    }

    protected EntitySqlDaoTransactionWrapper<List<M>> getCreateEntitySqlDaoTransactionWrapper(final Iterable<M> entities, final InternalCallContext context) {
        final ArrayList result = new ArrayList();
        return new EntitySqlDaoTransactionWrapper<List<M>>(){

            @Override
            public List<M> inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                Object transactional = entitySqlDaoWrapperFactory.become(EntityDaoBase.this.realSqlDao);
                for (EntityModelDao entity : entities) {
                    if (EntityDaoBase.this.checkEntityAlreadyExists(transactional, entity, context)) {
                        throw EntityDaoBase.this.generateAlreadyExistsException(entity, context);
                    }
                    EntityModelDao refreshedEntity = EntityDaoBase.this.createAndRefresh((EntitySqlDao)transactional, entity, context);
                    result.add(refreshedEntity);
                    EntityDaoBase.this.postBusEventFromTransaction(entity, refreshedEntity, ChangeType.INSERT, entitySqlDaoWrapperFactory, context);
                }
                return result;
            }
        };
    }

    protected EntitySqlDaoTransactionWrapper<M> getCreateEntitySqlDaoTransactionWrapper(M entity, InternalCallContext context) {
        final EntitySqlDaoTransactionWrapper<ImmutableList> entityWrapperList = this.getCreateEntitySqlDaoTransactionWrapper(ImmutableList.of(entity), context);
        return new EntitySqlDaoTransactionWrapper<M>(){

            @Override
            public M inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                List result = (List)entityWrapperList.inTransaction(entitySqlDaoWrapperFactory);
                return result.isEmpty() ? null : (EntityModelDao)result.get(0);
            }
        };
    }

    protected <F extends EntityModelDao> F createAndRefresh(EntitySqlDao transactional, F entity, InternalCallContext context) {
        return (F)((EntityModelDao)transactional.create(entity, context));
    }

    protected <F extends EntityModelDao> void bulkCreate(EntitySqlDao transactional, List<F> entities, InternalCallContext context) {
        if (entities.isEmpty()) {
            return;
        }
        if (entities.size() == 1) {
            transactional.create((EntityModelDao)entities.get(0), context);
        } else {
            transactional.create(entities, context);
        }
    }

    protected boolean checkEntityAlreadyExists(EntitySqlDao<M, E> transactional, M entity, InternalCallContext context) {
        if (entity.getTableName().getObjectType() == null) {
            return false;
        }
        return this.getRecordId(entity) != null;
    }

    @VisibleForTesting
    public Long getRecordId(M entity) {
        return this.nonEntityDao.retrieveRecordIdFromObject(entity.getId(), entity.getTableName().getObjectType(), this.recordIdCacheController);
    }

    protected void postBusEventFromTransaction(M entity, M savedEntity, ChangeType changeType, EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory, InternalCallContext context) throws BillingExceptionBase {
    }

    protected abstract U generateAlreadyExistsException(M var1, InternalCallContext var2);

    protected String getNaturalOrderingColumns() {
        return "record_id";
    }

    @Override
    public M getByRecordId(final Long recordId, final InternalTenantContext context) {
        return (M)((EntityModelDao)this.transactionalSqlDao.execute(true, new EntitySqlDaoTransactionWrapper<M>(){

            @Override
            public M inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                Object transactional = entitySqlDaoWrapperFactory.become(EntityDaoBase.this.realSqlDao);
                return transactional.getByRecordId(recordId, context);
            }
        }));
    }

    @Override
    public M getById(final UUID id, final InternalTenantContext context) throws U {
        return (M)((EntityModelDao)this.transactionalSqlDao.execute(true, new EntitySqlDaoTransactionWrapper<M>(){

            @Override
            public M inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                Object transactional = entitySqlDaoWrapperFactory.become(EntityDaoBase.this.realSqlDao);
                return transactional.getById(id.toString(), context);
            }
        }));
    }

    @Override
    public Pagination<M> getAll(InternalTenantContext context) {
        EntitySqlDao<M, E> sqlDao = this.transactionalSqlDao.onDemandForStreamingResults(this.realSqlDao);
        Long count = sqlDao.getCount(context);
        Iterator<M> results = sqlDao.getAll(context);
        return new DefaultPagination<M>(count, results);
    }

    @Override
    public Pagination<M> get(Long offset, Long limit, InternalTenantContext context) {
        return this.paginationHelper.getPagination(this.realSqlDao, new DefaultPaginationSqlDaoHelper.PaginationIteratorBuilder<M, E, EntitySqlDao<M, E>>(){

            @Override
            public Long getCount(EntitySqlDao<M, E> sqlDao, InternalTenantContext context) {
                return null;
            }

            @Override
            public Iterator<M> build(EntitySqlDao<M, E> sqlDao, Long offset, Long limit, DefaultPaginationSqlDaoHelper.Ordering ordering, InternalTenantContext context) {
                return sqlDao.get(offset, limit, EntityDaoBase.this.getNaturalOrderingColumns(), ordering.toString(), context);
            }
        }, offset, limit, context);
    }

    @Override
    public Long getCount(final InternalTenantContext context) {
        return this.transactionalSqlDao.execute(true, new EntitySqlDaoTransactionWrapper<Long>(){

            @Override
            public Long inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                Object transactional = entitySqlDaoWrapperFactory.become(EntityDaoBase.this.realSqlDao);
                return transactional.getCount(context);
            }
        });
    }

    @Override
    public void test(final InternalTenantContext context) {
        this.transactionalSqlDao.execute(true, new EntitySqlDaoTransactionWrapper<Void>(){

            @Override
            public Void inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                Object transactional = entitySqlDaoWrapperFactory.become(EntityDaoBase.this.realSqlDao);
                transactional.test(context);
                return null;
            }
        });
    }
}

