/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.entity.dao;

import javax.annotation.Nullable;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.entity.Entity;
import org.killbill.billing.util.entity.dao.DBRouterUntyped;
import org.killbill.billing.util.entity.dao.EntityModelDao;
import org.killbill.billing.util.entity.dao.EntitySqlDao;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoWrapperFactory;
import org.killbill.billing.util.entity.dao.EntitySqlDaoWrapperInvocationHandler;
import org.killbill.clock.Clock;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.Transaction;
import org.skife.jdbi.v2.TransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySqlDaoTransactionalJdbiWrapper {
    private static final Logger logger = LoggerFactory.getLogger(EntitySqlDaoTransactionalJdbiWrapper.class);
    private final DBRouterUntyped dbRouter;
    private final Clock clock;
    private final CacheControllerDispatcher cacheControllerDispatcher;
    private final NonEntityDao nonEntityDao;
    private final InternalCallContextFactory internalCallContextFactory;

    public EntitySqlDaoTransactionalJdbiWrapper(IDBI dbi, IDBI roDbi, Clock clock, CacheControllerDispatcher cacheControllerDispatcher, NonEntityDao nonEntityDao, InternalCallContextFactory internalCallContextFactory) {
        this.clock = clock;
        this.cacheControllerDispatcher = cacheControllerDispatcher;
        this.nonEntityDao = nonEntityDao;
        this.internalCallContextFactory = internalCallContextFactory;
        this.dbRouter = new DBRouterUntyped(dbi, roDbi);
    }

    public <M extends EntityModelDao> void populateCaches(M refreshedEntity) {
        EntitySqlDaoWrapperInvocationHandler.populateCaches(this.cacheControllerDispatcher, refreshedEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ReturnType> ReturnType execute(boolean requestedRO, EntitySqlDaoTransactionWrapper<ReturnType> entitySqlDaoTransactionWrapper) {
        String debugInfo = logger.isDebugEnabled() ? EntitySqlDaoTransactionalJdbiWrapper.getDebugInfo() : null;
        Handle handle = this.dbRouter.getHandle(requestedRO);
        logger.debug("DBI handle created, transaction: {}", (Object)debugInfo);
        try {
            EntitySqlDao entitySqlDao = (EntitySqlDao)handle.attach(InitialEntitySqlDao.class);
            logger.debug("Starting transaction {}", (Object)debugInfo);
            Object returnType = entitySqlDao.inTransaction(new JdbiTransaction(handle, entitySqlDaoTransactionWrapper));
            logger.debug("Exiting  transaction {}, returning {}", (Object)debugInfo, returnType);
            Object object = returnType;
            return (ReturnType)object;
        }
        finally {
            handle.close();
            logger.debug("DBI handle closed,  transaction: {}", (Object)debugInfo);
        }
    }

    public <M extends EntityModelDao<E>, E extends Entity, T extends EntitySqlDao<M, E>> T onDemandForStreamingResults(Class<T> sqlObjectType) {
        return (T)((EntitySqlDao)this.dbRouter.onDemand(true, sqlObjectType));
    }

    public <ReturnType, E extends Exception> ReturnType execute(boolean ro, @Nullable Class<E> exception, EntitySqlDaoTransactionWrapper<ReturnType> entitySqlDaoTransactionWrapper) throws E {
        try {
            return this.execute(ro, entitySqlDaoTransactionWrapper);
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && exception != null && e.getCause().getClass().isAssignableFrom(exception)) {
                throw (Exception)e.getCause();
            }
            if (e.getCause() != null && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    private static String getDebugInfo() {
        Throwable t = new Throwable();
        t.fillInStackTrace();
        StackTraceElement[] stackTrace = t.getStackTrace();
        if (stackTrace == null) {
            return null;
        }
        StringBuilder dump = new StringBuilder();
        int firstEntitySqlDaoCall = 0;
        for (int i = 0; i < stackTrace.length; ++i) {
            String className = stackTrace[i].getClassName();
            if (!className.startsWith("org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionalJdbiWrapper")) continue;
            firstEntitySqlDaoCall = i;
        }
        int j = 1 + firstEntitySqlDaoCall;
        dump.append(stackTrace[j].getClassName()).append(".").append(stackTrace[j].getMethodName()).append("(").append(stackTrace[j].getFileName()).append(":").append(stackTrace[j].getLineNumber()).append(")");
        return dump.toString();
    }

    static interface InitialEntitySqlDao
    extends EntitySqlDao<EntityModelDao<Entity>, Entity> {
    }

    class JdbiTransaction<ReturnType, M extends EntityModelDao<E>, E extends Entity>
    implements Transaction<ReturnType, EntitySqlDao<M, E>> {
        private final Handle h;
        private final EntitySqlDaoTransactionWrapper<ReturnType> entitySqlDaoTransactionWrapper;

        JdbiTransaction(Handle h, EntitySqlDaoTransactionWrapper<ReturnType> entitySqlDaoTransactionWrapper) {
            this.h = h;
            this.entitySqlDaoTransactionWrapper = entitySqlDaoTransactionWrapper;
        }

        public ReturnType inTransaction(EntitySqlDao<M, E> transactionalSqlDao, TransactionStatus status) throws Exception {
            EntitySqlDaoWrapperFactory factoryEntitySqlDao = new EntitySqlDaoWrapperFactory(this.h, EntitySqlDaoTransactionalJdbiWrapper.this.clock, EntitySqlDaoTransactionalJdbiWrapper.this.cacheControllerDispatcher, EntitySqlDaoTransactionalJdbiWrapper.this.internalCallContextFactory);
            return this.entitySqlDaoTransactionWrapper.inTransaction(factoryEntitySqlDao);
        }
    }
}

