/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.entity.dao;

import java.lang.reflect.Proxy;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.entity.Entity;
import org.killbill.billing.util.entity.dao.EntityModelDao;
import org.killbill.billing.util.entity.dao.EntitySqlDao;
import org.killbill.billing.util.entity.dao.EntitySqlDaoWrapperInvocationHandler;
import org.killbill.clock.Clock;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.sqlobject.SqlObjectBuilder;

public class EntitySqlDaoWrapperFactory {
    private final Handle handle;
    private final Clock clock;
    private final CacheControllerDispatcher cacheControllerDispatcher;
    private final InternalCallContextFactory internalCallContextFactory;

    public EntitySqlDaoWrapperFactory(Handle handle, Clock clock, CacheControllerDispatcher cacheControllerDispatcher, InternalCallContextFactory internalCallContextFactory) {
        this.handle = handle;
        this.clock = clock;
        this.cacheControllerDispatcher = cacheControllerDispatcher;
        this.internalCallContextFactory = internalCallContextFactory;
    }

    public <NewSqlDao extends EntitySqlDao<NewEntityModelDao, NewEntity>, NewEntityModelDao extends EntityModelDao<NewEntity>, NewEntity extends Entity> NewSqlDao become(Class<NewSqlDao> newSqlDaoClass) {
        EntitySqlDao newSqlDao = (EntitySqlDao)SqlObjectBuilder.attach((Handle)this.handle, newSqlDaoClass);
        return (NewSqlDao)this.create(newSqlDaoClass, newSqlDao);
    }

    public Handle getHandle() {
        return this.handle;
    }

    private <NewSqlDao extends EntitySqlDao<NewEntityModelDao, NewEntity>, NewEntityModelDao extends EntityModelDao<NewEntity>, NewEntity extends Entity> NewSqlDao create(Class<NewSqlDao> newSqlDaoClass, NewSqlDao newSqlDao) {
        ClassLoader classLoader = newSqlDao.getClass().getClassLoader();
        Class[] interfacesToImplement = new Class[]{newSqlDaoClass};
        EntitySqlDaoWrapperInvocationHandler wrapperInvocationHandler = new EntitySqlDaoWrapperInvocationHandler(newSqlDaoClass, newSqlDao, this.handle, this.clock, this.cacheControllerDispatcher, this.internalCallContextFactory);
        Object newSqlDaoObject = Proxy.newProxyInstance(classLoader, interfacesToImplement, wrapperInvocationHandler);
        return (NewSqlDao)((EntitySqlDao)newSqlDaoClass.cast(newSqlDaoObject));
    }
}

