/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.entity.dao;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.audit.ChangeType;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheController;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.dao.EntityAudit;
import org.killbill.billing.util.dao.EntityHistoryModelDao;
import org.killbill.billing.util.dao.TableName;
import org.killbill.billing.util.entity.Entity;
import org.killbill.billing.util.entity.dao.Audited;
import org.killbill.billing.util.entity.dao.EntityModelDao;
import org.killbill.billing.util.entity.dao.EntitySqlDao;
import org.killbill.billing.util.entity.dao.TimeZoneAwareEntity;
import org.killbill.clock.Clock;
import org.killbill.commons.profiling.Profiling;
import org.killbill.commons.profiling.ProfilingFeature;
import org.skife.jdbi.v2.Binding;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.exceptions.DBIException;
import org.skife.jdbi.v2.exceptions.StatementException;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SqlBatch;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.unstable.BindIn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySqlDaoWrapperInvocationHandler<S extends EntitySqlDao<M, E>, M extends EntityModelDao<E>, E extends Entity>
implements InvocationHandler {
    private final Logger logger = LoggerFactory.getLogger(EntitySqlDaoWrapperInvocationHandler.class);
    private final Map<String, Annotation[][]> parameterAnnotationsByMethod = new ConcurrentHashMap<String, Annotation[][]>();
    private final Class<S> sqlDaoClass;
    private final S sqlDao;
    private final Handle handle;
    private final CacheControllerDispatcher cacheControllerDispatcher;
    private final Clock clock;
    private final InternalCallContextFactory internalCallContextFactory;
    private final Profiling<Object, Throwable> prof;

    public EntitySqlDaoWrapperInvocationHandler(Class<S> sqlDaoClass, S sqlDao, Handle handle, Clock clock, @Nullable CacheControllerDispatcher cacheControllerDispatcher, InternalCallContextFactory internalCallContextFactory) {
        this.sqlDaoClass = sqlDaoClass;
        this.sqlDao = sqlDao;
        this.handle = handle;
        this.clock = clock;
        this.cacheControllerDispatcher = cacheControllerDispatcher;
        this.internalCallContextFactory = internalCallContextFactory;
        this.prof = new Profiling();
    }

    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        try {
            return this.prof.executeWithProfiling(ProfilingFeature.ProfilingFeatureType.DAO, this.getProfilingId(null, method), (Profiling.WithProfilingCallback)new Profiling.WithProfilingCallback<Object, Throwable>(){

                public Object execute() throws Throwable {
                    return EntitySqlDaoWrapperInvocationHandler.this.invokeSafely(method, args);
                }
            });
        }
        catch (Throwable t) {
            if (t.getCause() != null && t.getCause().getCause() != null && DBIException.class.isAssignableFrom(t.getCause().getClass())) {
                StatementContext statementContext;
                if (t.getCause() instanceof StatementException && (statementContext = ((StatementException)t.getCause()).getStatementContext()) != null) {
                    Binding binding = statementContext.getBinding();
                    PreparedStatement statement = statementContext.getStatement();
                    if (statement != null) {
                        this.errorDuringTransaction(t.getCause().getCause(), method, statement.toString() + "\n" + binding.toString());
                    } else {
                        this.errorDuringTransaction(t.getCause().getCause(), method, binding.toString());
                    }
                    return null;
                }
                this.errorDuringTransaction(t.getCause().getCause(), method);
            } else if (t.getCause() != null) {
                this.errorDuringTransaction(t.getCause(), method);
            } else {
                this.errorDuringTransaction(t, method);
            }
            return null;
        }
    }

    private void errorDuringTransaction(Throwable t, Method method, String extraErrorMessage) throws Throwable {
        StringBuilder errorMessageBuilder = new StringBuilder("Error during transaction for sql entity {} and method {}");
        if (t instanceof SQLException) {
            SQLException sqlException = (SQLException)t;
            errorMessageBuilder.append(" [SQL DefaultState: ").append(sqlException.getSQLState()).append(", Vendor Error Code: ").append(sqlException.getErrorCode()).append("]");
        }
        if (extraErrorMessage != null) {
            errorMessageBuilder.append("\n").append(extraErrorMessage);
        }
        this.logger.warn(errorMessageBuilder.toString(), this.sqlDaoClass, (Object)method.getName());
        if (!(t instanceof RuntimeException)) {
            throw new RuntimeException(t);
        }
        throw t;
    }

    private void errorDuringTransaction(Throwable t, Method method) throws Throwable {
        this.errorDuringTransaction(t, method, null);
    }

    private Object invokeSafely(Method method, Object[] args) throws Throwable {
        Audited auditedAnnotation = method.getAnnotation(Audited.class);
        boolean isROQuery = method.getAnnotation(SqlQuery.class) != null;
        Preconditions.checkState((auditedAnnotation != null || isROQuery ? 1 : 0) != 0, (String)"Non-@SqlQuery method %s without @Audited annotation", (Object)method);
        if (auditedAnnotation != null) {
            return this.invokeWithAuditAndHistory(auditedAnnotation, method, args);
        }
        return this.invokeRaw(method, args);
    }

    private Object invokeRaw(final Method method, final Object[] args) throws Throwable {
        return this.prof.executeWithProfiling(ProfilingFeature.ProfilingFeatureType.DAO_DETAILS, this.getProfilingId("raw", method), (Profiling.WithProfilingCallback)new Profiling.WithProfilingCallback<Object, Throwable>(){

            public Object execute() throws Throwable {
                Object result = EntitySqlDaoWrapperInvocationHandler.this.executeJDBCCall(method, args);
                if (result != null && method.getName().equals("getById")) {
                    EntitySqlDaoWrapperInvocationHandler.this.populateCacheOnGetByIdInvocation((EntityModelDao)result);
                }
                return result;
            }
        });
    }

    private Object invokeWithAuditAndHistory(Audited auditedAnnotation, final Method method, final Object[] args) throws Throwable {
        InternalCallContext contextMaybeWithoutAccountRecordId = this.retrieveContextFromArguments(args);
        List<String> entityIds = this.retrieveEntityIdsFromArguments(method, args);
        Preconditions.checkState((!entityIds.isEmpty() ? 1 : 0) != 0, (Object)"@Audited Sql method must have entities (@Bind(\"id\")) as arguments");
        TableName tableName = this.retrieveTableNameFromArgumentsIfPossible(Arrays.asList(args));
        ChangeType changeType = auditedAnnotation.value();
        boolean isBatchQuery = method.getAnnotation(SqlBatch.class) != null;
        HashMap<Long, EntityModelDao> deletedAndUpdatedEntities = new HashMap<Long, EntityModelDao>();
        Object obj = this.prof.executeWithProfiling(ProfilingFeature.ProfilingFeatureType.DAO_DETAILS, this.getProfilingId("raw", method), (Profiling.WithProfilingCallback)new Profiling.WithProfilingCallback<Object, Throwable>(){

            public Object execute() throws Throwable {
                return EntitySqlDaoWrapperInvocationHandler.this.executeJDBCCall(method, args);
            }
        });
        if (entityIds.isEmpty()) {
            return obj;
        }
        InternalCallContext context = null;
        LinkedList<Long> entityRecordIds = new LinkedList<Long>();
        if (changeType == ChangeType.INSERT) {
            Preconditions.checkNotNull((Object)((Object)tableName), (String)"Insert query should have an EntityModelDao as argument: %s", (Object[])args);
            if (isBatchQuery) {
                entityRecordIds.addAll((Collection)obj);
            } else {
                entityRecordIds.add((Long)obj);
            }
            if (TableName.ACCOUNT.equals((Object)tableName)) {
                Preconditions.checkState((entityIds.size() == 1 ? 1 : 0) != 0, (Object)"Bulk insert of accounts isn't supported");
                TimeZoneAwareEntity accountModelDao = this.retrieveTimeZoneAwareEntityFromArguments(args);
                context = this.internalCallContextFactory.createInternalCallContext(accountModelDao, (Long)entityRecordIds.get(0), contextMaybeWithoutAccountRecordId);
            }
        } else {
            List retrievedEntities = this.sqlDao.getByIdsIncludedDeleted(entityIds, (InternalTenantContext)contextMaybeWithoutAccountRecordId);
            this.printSQLWarnings();
            for (EntityModelDao entity : retrievedEntities) {
                deletedAndUpdatedEntities.put(entity.getRecordId(), entity);
                entityRecordIds.add(entity.getRecordId());
                if (tableName == null) {
                    tableName = entity.getTableName();
                    continue;
                }
                Preconditions.checkState((tableName == entity.getTableName() ? 1 : 0) != 0, (Object)"Entities with different TableName");
            }
        }
        Preconditions.checkState((entityIds.size() == entityRecordIds.size() ? 1 : 0) != 0, (String)"SqlDao method has %s as ids but found %s as recordIds", entityIds, entityRecordIds);
        if (context != null) {
            Preconditions.checkState((entityIds.size() == 1 ? 1 : 0) != 0, (Object)"Bulk insert of accounts isn't supported");
        } else {
            context = contextMaybeWithoutAccountRecordId;
            boolean tableWithoutAccountRecordId = tableName == TableName.TENANT || tableName == TableName.TENANT_BROADCASTS || tableName == TableName.TENANT_KVS || tableName == TableName.TAG_DEFINITIONS || tableName == TableName.SERVICE_BRODCASTS || tableName == TableName.NODE_INFOS;
            Preconditions.checkState((context.getAccountRecordId() != null || tableWithoutAccountRecordId ? 1 : 0) != 0, (String)"accountRecordId should be set for tableName=%s and changeType=%s", (Object)((Object)tableName), (Object)changeType);
        }
        Collection reHydratedEntities = this.updateHistoryAndAudit(entityRecordIds, deletedAndUpdatedEntities, tableName, changeType, context);
        if (method.getReturnType().equals(Void.TYPE)) {
            return null;
        }
        if (isBatchQuery) {
            return obj;
        }
        Preconditions.checkState((entityRecordIds.size() == 1 ? 1 : 0) != 0, (String)"Invalid number of entityRecordIds: %s", entityRecordIds);
        if (!reHydratedEntities.isEmpty()) {
            Preconditions.checkState((reHydratedEntities.size() == 1 ? 1 : 0) != 0, (String)"Invalid number of entities: %s", reHydratedEntities);
            return Iterables.getFirst(reHydratedEntities, null);
        }
        Object entity = this.sqlDao.getByRecordId((Long)entityRecordIds.get(0), (InternalTenantContext)context);
        this.printSQLWarnings();
        return entity;
    }

    private Object executeJDBCCall(Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
        Object invoke = method.invoke(this.sqlDao, args);
        this.printSQLWarnings();
        return invoke;
    }

    private void printSQLWarnings() {
        if (this.logger.isDebugEnabled()) {
            try {
                for (SQLWarning warning = this.handle.getConnection().getWarnings(); warning != null; warning = warning.getNextWarning()) {
                    this.logger.debug("[SQL WARNING] {}", (Throwable)warning);
                }
                this.handle.getConnection().clearWarnings();
            }
            catch (SQLException e) {
                this.logger.debug("Error whilst retrieving SQL warnings", (Throwable)e);
            }
        }
    }

    private void populateCacheOnGetByIdInvocation(M model) {
        EntitySqlDaoWrapperInvocationHandler.populateCaches(this.cacheControllerDispatcher, model);
    }

    public static void populateCaches(CacheControllerDispatcher cacheControllerDispatcher, EntityModelDao model) {
        CacheController<String, Long> cacheRecordId = cacheControllerDispatcher.getCacheController(Cachable.CacheType.RECORD_ID);
        cacheRecordId.putIfAbsent(EntitySqlDaoWrapperInvocationHandler.getKey(model.getId().toString(), Cachable.CacheType.RECORD_ID, model.getTableName()), model.getRecordId());
        CacheController<String, UUID> cacheObjectId = cacheControllerDispatcher.getCacheController(Cachable.CacheType.OBJECT_ID);
        cacheObjectId.putIfAbsent(EntitySqlDaoWrapperInvocationHandler.getKey(model.getRecordId().toString(), Cachable.CacheType.OBJECT_ID, model.getTableName()), model.getId());
        if (model.getTenantRecordId() != null) {
            CacheController<String, Long> cacheTenantRecordId = cacheControllerDispatcher.getCacheController(Cachable.CacheType.TENANT_RECORD_ID);
            cacheTenantRecordId.putIfAbsent(EntitySqlDaoWrapperInvocationHandler.getKey(model.getId().toString(), Cachable.CacheType.TENANT_RECORD_ID, model.getTableName()), model.getTenantRecordId());
        }
        if (model.getAccountRecordId() != null) {
            CacheController<String, Long> cacheAccountRecordId = cacheControllerDispatcher.getCacheController(Cachable.CacheType.ACCOUNT_RECORD_ID);
            cacheAccountRecordId.putIfAbsent(EntitySqlDaoWrapperInvocationHandler.getKey(model.getId().toString(), Cachable.CacheType.ACCOUNT_RECORD_ID, model.getTableName()), model.getAccountRecordId());
        }
    }

    private static String getKey(String rawKey, Cachable.CacheType cacheType, TableName tableName) {
        return cacheType.isKeyPrefixedWithTableName() ? (Object)((Object)tableName) + "::" + rawKey : rawKey;
    }

    private Collection<M> updateHistoryAndAudit(final List<Long> entityRecordIds, final Map<Long, M> deletedAndUpdatedEntities, final TableName tableName, final ChangeType changeType, final InternalCallContext context) throws Throwable {
        Object reHydratedEntitiesOrNull = this.prof.executeWithProfiling(ProfilingFeature.ProfilingFeatureType.DAO_DETAILS, this.getProfilingId("history/audit", null), (Profiling.WithProfilingCallback)new Profiling.WithProfilingCallback<Object, Throwable>(){

            public Collection<M> execute() {
                if (tableName.getHistoryTableName() == null) {
                    EntitySqlDaoWrapperInvocationHandler.this.insertAudits(entityRecordIds, tableName, changeType, context);
                    return deletedAndUpdatedEntities.values();
                }
                ArrayList<Object> reHydratedEntities = new ArrayList<Object>(entityRecordIds.size());
                if (deletedAndUpdatedEntities.isEmpty()) {
                    reHydratedEntities.addAll(EntitySqlDaoWrapperInvocationHandler.this.sqlDao.getByRecordIds(entityRecordIds, (InternalTenantContext)context));
                    EntitySqlDaoWrapperInvocationHandler.this.printSQLWarnings();
                } else {
                    reHydratedEntities.addAll(deletedAndUpdatedEntities.values());
                }
                Preconditions.checkState((reHydratedEntities.size() == entityRecordIds.size() ? 1 : 0) != 0, (String)"Wrong number of reHydratedEntities=%s (entityRecordIds=%s)", reHydratedEntities, (Object)entityRecordIds);
                List auditTargetRecordIds = EntitySqlDaoWrapperInvocationHandler.this.insertHistories(reHydratedEntities, changeType, context);
                Preconditions.checkState((auditTargetRecordIds.size() == entityRecordIds.size() ? 1 : 0) != 0, (String)"Wrong number of auditTargetRecordIds=%s (entityRecordIds=%s)", (Object)auditTargetRecordIds, (Object)entityRecordIds);
                EntitySqlDaoWrapperInvocationHandler.this.insertAudits(auditTargetRecordIds, tableName, changeType, context);
                return reHydratedEntities;
            }
        });
        return (Collection)reHydratedEntitiesOrNull;
    }

    private List<String> retrieveEntityIdsFromArguments(Method method, Object[] args) {
        Annotation[][] parameterAnnotations = this.getAnnotations(method);
        int i = -1;
        for (Object arg : args) {
            ImmutableList.Builder<String> entityIds;
            ++i;
            if (arg instanceof Entity) {
                return ImmutableList.of((Object)((Entity)arg).getId().toString());
            }
            if (arg instanceof Iterable && (entityIds = this.extractEntityIdsFromBatchArgument((Iterable)arg)) != null) {
                return entityIds.build();
            }
            for (Annotation annotation : parameterAnnotations[i]) {
                if (arg instanceof String && Bind.class.equals(annotation.annotationType()) && "id".equals(((Bind)annotation).value())) {
                    return ImmutableList.of((Object)((String)arg));
                }
                if (!(arg instanceof Collection) || !BindIn.class.equals(annotation.annotationType()) || !"ids".equals(((BindIn)annotation).value())) continue;
                return ImmutableList.copyOf((Collection)((Collection)arg));
            }
        }
        return ImmutableList.of();
    }

    private Annotation[][] getAnnotations(Method method) {
        String methodString = method.toString();
        Annotation[][] parameterAnnotations = this.parameterAnnotationsByMethod.get(methodString);
        if (parameterAnnotations == null) {
            parameterAnnotations = method.getParameterAnnotations();
            this.parameterAnnotationsByMethod.put(methodString, parameterAnnotations);
        }
        return parameterAnnotations;
    }

    private ImmutableList.Builder<String> extractEntityIdsFromBatchArgument(Iterable arg) {
        Iterator iterator = arg.iterator();
        ImmutableList.Builder entityIds = new ImmutableList.Builder();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Entity)) {
                return null;
            }
            entityIds.add((Object)((Entity)object).getId().toString());
        }
        return entityIds;
    }

    private InternalCallContext retrieveContextFromArguments(Object[] args) {
        for (Object arg : args) {
            if (!(arg instanceof InternalCallContext)) continue;
            return (InternalCallContext)arg;
        }
        throw new IllegalStateException("No InternalCallContext specified in args: " + Arrays.toString(args));
    }

    private TableName retrieveTableNameFromArgumentsIfPossible(Iterable args) {
        TableName tableName = null;
        for (Object arg : args) {
            TableName argTableName = null;
            if (arg instanceof EntityModelDao) {
                argTableName = ((EntityModelDao)arg).getTableName();
            } else if (arg instanceof Iterable) {
                argTableName = this.retrieveTableNameFromArgumentsIfPossible((Iterable)arg);
            }
            if (tableName == null) {
                tableName = argTableName;
                continue;
            }
            if (argTableName == null) continue;
            Preconditions.checkState((tableName == argTableName ? 1 : 0) != 0, (String)"SqlDao method with different TableName in args: %s", (Object)args);
        }
        return tableName;
    }

    private TimeZoneAwareEntity retrieveTimeZoneAwareEntityFromArguments(Object[] args) {
        for (Object arg : args) {
            if (!(arg instanceof TimeZoneAwareEntity)) continue;
            return (TimeZoneAwareEntity)arg;
        }
        throw new IllegalStateException("TimeZoneAwareEntity should have been found among " + args);
    }

    private List<Long> insertHistories(Iterable<M> reHydratedEntityModelDaos, ChangeType changeType, InternalCallContext context) {
        LinkedList histories = new LinkedList();
        for (EntityModelDao reHydratedEntityModelDao : reHydratedEntityModelDaos) {
            EntityHistoryModelDao history = new EntityHistoryModelDao(reHydratedEntityModelDao, reHydratedEntityModelDao.getRecordId(), changeType, null, context.getCreatedDate());
            histories.add(history);
        }
        List<Long> recordIds = this.sqlDao.addHistoriesFromTransaction(histories, context);
        this.printSQLWarnings();
        return recordIds;
    }

    private void insertAudits(Iterable<Long> auditTargetRecordIds, TableName tableName, ChangeType changeType, InternalCallContext context) {
        TableName destinationTableName = (TableName)((Object)MoreObjects.firstNonNull((Object)((Object)tableName.getHistoryTableName()), (Object)((Object)tableName)));
        LinkedList<EntityAudit> audits = new LinkedList<EntityAudit>();
        for (Long auditTargetRecordId : auditTargetRecordIds) {
            EntityAudit audit = new EntityAudit(destinationTableName, auditTargetRecordId, changeType, context.getCreatedDate());
            audits.add(audit);
        }
        this.sqlDao.insertAuditsFromTransaction(audits, context);
        this.printSQLWarnings();
    }

    private String getProfilingId(@Nullable String prefix, @Nullable Method method) {
        StringBuilder stringBuilder = new StringBuilder().append(this.sqlDaoClass.getSimpleName());
        if (prefix != null) {
            stringBuilder.append(" (").append(prefix).append(")");
        }
        if (method != null) {
            stringBuilder.append(": ").append(method.getName());
        }
        return stringBuilder.toString();
    }
}

