/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.glue;

import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import java.lang.annotation.Annotation;
import javax.cache.CacheManager;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.util.cache.AccountBCDCacheLoader;
import org.killbill.billing.util.cache.AccountIdFromBundleIdCacheLoader;
import org.killbill.billing.util.cache.AccountRecordIdCacheLoader;
import org.killbill.billing.util.cache.BaseCacheLoader;
import org.killbill.billing.util.cache.BundleIdFromSubscriptionIdCacheLoader;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.cache.CacheControllerDispatcherProvider;
import org.killbill.billing.util.cache.ImmutableAccountCacheLoader;
import org.killbill.billing.util.cache.ObjectIdCacheLoader;
import org.killbill.billing.util.cache.OverriddenPlanCacheLoader;
import org.killbill.billing.util.cache.RecordIdCacheLoader;
import org.killbill.billing.util.cache.TenantCacheLoader;
import org.killbill.billing.util.cache.TenantCatalogCacheLoader;
import org.killbill.billing.util.cache.TenantConfigCacheLoader;
import org.killbill.billing.util.cache.TenantKVCacheLoader;
import org.killbill.billing.util.cache.TenantOverdueConfigCacheLoader;
import org.killbill.billing.util.cache.TenantRecordIdCacheLoader;
import org.killbill.billing.util.cache.TenantStateMachineConfigCacheLoader;
import org.killbill.billing.util.config.definition.EhCacheConfig;
import org.killbill.billing.util.config.definition.RedisCacheConfig;
import org.killbill.billing.util.glue.Eh107CacheManagerProvider;
import org.killbill.billing.util.glue.KillBillModule;
import org.killbill.billing.util.glue.Redis107CacheManagerProvider;
import org.killbill.billing.util.glue.RedissonCacheClientProvider;
import org.redisson.api.RedissonClient;
import org.skife.config.ConfigurationObjectFactory;

public class CacheModule
extends KillBillModule {
    public static final String REDIS_CACHE_CLIENT = "redisCacheClient";

    public CacheModule(KillbillConfigSource configSource) {
        super(configSource);
    }

    protected void configure() {
        EhCacheConfig ehCacheConfig = (EhCacheConfig)new ConfigurationObjectFactory(this.skifeConfigSource).build(EhCacheConfig.class);
        this.bind(EhCacheConfig.class).toInstance((Object)ehCacheConfig);
        RedisCacheConfig redisCacheConfig = (RedisCacheConfig)new ConfigurationObjectFactory(this.skifeConfigSource).build(RedisCacheConfig.class);
        this.bind(RedisCacheConfig.class).toInstance((Object)redisCacheConfig);
        if (redisCacheConfig.isRedisCachingEnabled()) {
            this.bind(RedissonClient.class).annotatedWith((Annotation)Names.named((String)REDIS_CACHE_CLIENT)).toProvider(RedissonCacheClientProvider.class).asEagerSingleton();
            this.bind(CacheManager.class).toProvider(Redis107CacheManagerProvider.class).asEagerSingleton();
        } else {
            this.bind(RedissonClient.class).annotatedWith((Annotation)Names.named((String)REDIS_CACHE_CLIENT)).toProvider(Providers.of(null));
            this.bind(CacheManager.class).toProvider(Eh107CacheManagerProvider.class).asEagerSingleton();
        }
        this.bind(CacheControllerDispatcher.class).toProvider(CacheControllerDispatcherProvider.class).asEagerSingleton();
        Multibinder resultSetMapperSetBinder = Multibinder.newSetBinder((Binder)this.binder(), BaseCacheLoader.class);
        resultSetMapperSetBinder.addBinding().to(ImmutableAccountCacheLoader.class).asEagerSingleton();
        resultSetMapperSetBinder.addBinding().to(AccountBCDCacheLoader.class).asEagerSingleton();
        resultSetMapperSetBinder.addBinding().to(RecordIdCacheLoader.class).asEagerSingleton();
        resultSetMapperSetBinder.addBinding().to(AccountRecordIdCacheLoader.class).asEagerSingleton();
        resultSetMapperSetBinder.addBinding().to(TenantRecordIdCacheLoader.class).asEagerSingleton();
        resultSetMapperSetBinder.addBinding().to(ObjectIdCacheLoader.class).asEagerSingleton();
        resultSetMapperSetBinder.addBinding().to(TenantCatalogCacheLoader.class).asEagerSingleton();
        resultSetMapperSetBinder.addBinding().to(TenantConfigCacheLoader.class).asEagerSingleton();
        resultSetMapperSetBinder.addBinding().to(TenantOverdueConfigCacheLoader.class).asEagerSingleton();
        resultSetMapperSetBinder.addBinding().to(TenantKVCacheLoader.class).asEagerSingleton();
        resultSetMapperSetBinder.addBinding().to(TenantCacheLoader.class).asEagerSingleton();
        resultSetMapperSetBinder.addBinding().to(OverriddenPlanCacheLoader.class).asEagerSingleton();
        resultSetMapperSetBinder.addBinding().to(TenantStateMachineConfigCacheLoader.class).asEagerSingleton();
        resultSetMapperSetBinder.addBinding().to(AccountIdFromBundleIdCacheLoader.class).asEagerSingleton();
        resultSetMapperSetBinder.addBinding().to(BundleIdFromSubscriptionIdCacheLoader.class).asEagerSingleton();
    }
}

