/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.glue;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jcache.JCacheGaugeSet;
import com.google.common.base.Preconditions;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;

abstract class CacheProviderBase {
    private static final String PROP_METRIC_REG_JCACHE_STATISTICS = "jcache.statistics";
    private final MetricRegistry metricRegistry;

    CacheProviderBase(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    <C extends Configuration> void createCache(CacheManager cacheManager, String cacheName, C configuration) {
        cacheManager.destroyCache(cacheName);
        Cache cache = cacheManager.createCache(cacheName, configuration);
        Preconditions.checkState((!cache.isClosed() ? 1 : 0) != 0, (String)"Cache '%s' should not be closed", (Object)cacheName);
        this.metricRegistry.removeMatching(new MetricFilter(){

            public boolean matches(String name, Metric metric) {
                return name != null && name.startsWith(CacheProviderBase.PROP_METRIC_REG_JCACHE_STATISTICS);
            }
        });
        this.metricRegistry.register(PROP_METRIC_REG_JCACHE_STATISTICS, (Metric)new JCacheGaugeSet());
    }
}

