/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.glue;

import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.io.IOException;
import javax.sql.DataSource;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.util.glue.KillBillModule;
import org.killbill.commons.embeddeddb.EmbeddedDB;
import org.killbill.commons.locker.GlobalLocker;
import org.killbill.commons.locker.memory.MemoryGlobalLocker;
import org.killbill.commons.locker.mysql.MySqlGlobalLocker;
import org.killbill.commons.locker.postgresql.PostgreSQLGlobalLocker;

public class GlobalLockerModule
extends KillBillModule {
    public GlobalLockerModule(KillbillConfigSource configSource) {
        super(configSource);
    }

    @Provides
    @Singleton
    protected GlobalLocker provideGlobalLocker(DataSource dataSource, EmbeddedDB embeddedDB) throws IOException {
        if (EmbeddedDB.DBEngine.MYSQL.equals((Object)embeddedDB.getDBEngine())) {
            return new MySqlGlobalLocker(dataSource);
        }
        if (EmbeddedDB.DBEngine.POSTGRESQL.equals((Object)embeddedDB.getDBEngine())) {
            return new PostgreSQLGlobalLocker(dataSource);
        }
        return new MemoryGlobalLocker();
    }

    protected void configure() {
    }
}

