/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.glue;

import com.google.common.collect.ImmutableSet;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import java.util.Collection;
import java.util.Set;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.guice.ShiroModule;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SubjectDAO;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.text.IniRealm;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.util.config.definition.RbacConfig;
import org.killbill.billing.util.config.definition.RedisCacheConfig;
import org.killbill.billing.util.config.definition.SecurityConfig;
import org.killbill.billing.util.glue.EhcacheShiroManagerProvider;
import org.killbill.billing.util.glue.KillBillSubjectDAOProvider;
import org.killbill.billing.util.glue.RealmsFromShiroIniProvider;
import org.killbill.billing.util.glue.RedisShiroManagerProvider;
import org.killbill.billing.util.glue.SessionDAOProvider;
import org.killbill.billing.util.security.shiro.realm.KillBillJdbcRealm;
import org.killbill.billing.util.security.shiro.realm.KillBillJndiLdapRealm;
import org.killbill.billing.util.security.shiro.realm.KillBillOktaRealm;
import org.skife.config.ConfigSource;
import org.skife.config.ConfigurationObjectFactory;

public class KillBillShiroModule
extends ShiroModule {
    public static final String KILLBILL_LDAP_PROPERTY = "killbill.server.ldap";
    public static final String KILLBILL_OKTA_PROPERTY = "killbill.server.okta";
    public static final String KILLBILL_RBAC_PROPERTY = "killbill.server.rbac";
    private final KillbillConfigSource configSource;
    private final ConfigSource skifeConfigSource;
    private final DefaultSecurityManager defaultSecurityManager;

    public static boolean isLDAPEnabled() {
        return Boolean.parseBoolean(System.getProperty(KILLBILL_LDAP_PROPERTY, "false"));
    }

    public static boolean isOktaEnabled() {
        return Boolean.parseBoolean(System.getProperty(KILLBILL_OKTA_PROPERTY, "false"));
    }

    public static boolean isRBACEnabled() {
        return Boolean.parseBoolean(System.getProperty(KILLBILL_RBAC_PROPERTY, "true"));
    }

    public KillBillShiroModule(final KillbillConfigSource configSource) {
        this.configSource = configSource;
        this.skifeConfigSource = new ConfigSource(){

            public String getString(String propertyName) {
                return configSource.getString(propertyName);
            }
        };
        this.defaultSecurityManager = RealmsFromShiroIniProvider.get(this.skifeConfigSource);
    }

    protected void configureShiro() {
        RbacConfig config = (RbacConfig)new ConfigurationObjectFactory(new ConfigSource(){

            public String getString(String propertyName) {
                return KillBillShiroModule.this.configSource.getString(propertyName);
            }
        }).build(RbacConfig.class);
        this.bind(RbacConfig.class).toInstance((Object)config);
        this.bind(RbacConfig.class).toInstance((Object)config);
        SecurityConfig securityConfig = (SecurityConfig)new ConfigurationObjectFactory(this.skifeConfigSource).build(SecurityConfig.class);
        Collection realms = this.defaultSecurityManager.getRealms() != null ? this.defaultSecurityManager.getRealms() : ImmutableSet.of((Object)new IniRealm(securityConfig.getShiroResourcePath()));
        for (Realm realm : realms) {
            this.bindRealm().toInstance((Object)realm);
        }
        this.configureJDBCRealm();
        this.configureLDAPRealm();
        this.configureOktaRealm();
        this.expose((TypeLiteral)new TypeLiteral<Set<Realm>>(){});
    }

    protected void configureJDBCRealm() {
        this.bindRealm().to(KillBillJdbcRealm.class).asEagerSingleton();
    }

    protected void configureLDAPRealm() {
        if (KillBillShiroModule.isLDAPEnabled()) {
            this.bindRealm().to(KillBillJndiLdapRealm.class).asEagerSingleton();
        }
    }

    protected void configureOktaRealm() {
        if (KillBillShiroModule.isOktaEnabled()) {
            this.bindRealm().to(KillBillOktaRealm.class).asEagerSingleton();
        }
    }

    protected void bindSecurityManager(AnnotatedBindingBuilder<? super SecurityManager> bind) {
        bind.toInstance((Object)this.defaultSecurityManager);
        RedisCacheConfig redisCacheConfig = (RedisCacheConfig)new ConfigurationObjectFactory(new ConfigSource(){

            public String getString(String propertyName) {
                return KillBillShiroModule.this.configSource.getString(propertyName);
            }
        }).build(RedisCacheConfig.class);
        if (redisCacheConfig.isRedisCachingEnabled()) {
            this.bind(CacheManager.class).toProvider(RedisShiroManagerProvider.class).asEagerSingleton();
        } else {
            this.bind(CacheManager.class).toProvider(EhcacheShiroManagerProvider.class).asEagerSingleton();
        }
    }

    protected void bindSessionManager(AnnotatedBindingBuilder<SessionManager> bind) {
        bind.to(DefaultSessionManager.class).asEagerSingleton();
        this.bind(SubjectDAO.class).toProvider(KillBillSubjectDAOProvider.class).asEagerSingleton();
        this.bind(SessionDAO.class).toProvider(SessionDAOProvider.class).asEagerSingleton();
    }
}

