/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.glue;

import com.google.inject.AbstractModule;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.killbill.billing.KillbillApi;
import org.killbill.billing.osgi.api.ROTenantContext;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.entity.dao.DBRouterUntyped;
import org.killbill.commons.profiling.Profiling;
import org.killbill.commons.profiling.ProfilingFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KillbillApiAopModule
extends AbstractModule {
    private static final Logger logger = LoggerFactory.getLogger(KillbillApiAopModule.class);
    private static final Matcher<Method> SYNTHETIC_METHOD_MATCHER = new Matcher<Method>(){

        public boolean matches(Method method) {
            return method.isSynthetic();
        }

        public Matcher<Method> and(Matcher<? super Method> other) {
            throw new UnsupportedOperationException();
        }

        public Matcher<Method> or(Matcher<? super Method> other) {
            throw new UnsupportedOperationException();
        }
    };

    protected void configure() {
        this.bindInterceptor(Matchers.subclassesOf(KillbillApi.class), Matchers.not(SYNTHETIC_METHOD_MATCHER), new MethodInterceptor[]{new ProfilingMethodInterceptor()});
    }

    public static class ProfilingMethodInterceptor
    implements MethodInterceptor {
        private final Profiling<Object, Throwable> prof = new Profiling();

        public Object invoke(final MethodInvocation invocation) throws Throwable {
            Profiling.WithProfilingCallback<Object, Throwable> callback = new Profiling.WithProfilingCallback<Object, Throwable>(){

                public Object execute() throws Throwable {
                    logger.debug("Entering API call {}, arguments: {}", (Object)invocation.getMethod(), (Object)invocation.getArguments());
                    Object proceed = invocation.proceed();
                    logger.debug("Exiting  API call {}, returning: {}", (Object)invocation.getMethod(), proceed);
                    return proceed;
                }
            };
            if (this.forcedRODBI(invocation)) {
                return this.prof.executeWithProfiling(ProfilingFeature.ProfilingFeatureType.API, invocation.getMethod().getName(), (Profiling.WithProfilingCallback)new Profiling.WithProfilingCallback<Object, Throwable>((Profiling.WithProfilingCallback)callback){
                    final /* synthetic */ Profiling.WithProfilingCallback val$callback;
                    {
                        this.val$callback = withProfilingCallback;
                    }

                    public Object execute() throws Throwable {
                        return DBRouterUntyped.withRODBIAllowed(true, (Profiling.WithProfilingCallback<Object, Throwable>)this.val$callback);
                    }
                });
            }
            return this.prof.executeWithProfiling(ProfilingFeature.ProfilingFeatureType.API, invocation.getMethod().getName(), (Profiling.WithProfilingCallback)callback);
        }

        private boolean forcedRODBI(MethodInvocation invocation) {
            boolean safeROOperations;
            boolean bl = safeROOperations = "getTenantByApiKey".equals(invocation.getMethod().getName()) || "login".equals(invocation.getMethod().getName());
            if (safeROOperations) {
                return true;
            }
            Object[] arguments = invocation.getArguments();
            if (arguments.length == 0) {
                return false;
            }
            for (int i = arguments.length - 1; i >= 0; --i) {
                boolean pluginRequestROInstance;
                Object argument = arguments[i];
                boolean bl2 = pluginRequestROInstance = argument instanceof ROTenantContext && !(argument instanceof CallContext);
                if (!pluginRequestROInstance) continue;
                return true;
            }
            return false;
        }
    }
}

