/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.glue;

import com.codahale.metrics.MetricRegistry;
import com.google.inject.name.Named;
import java.util.Set;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import javax.inject.Inject;
import javax.inject.Provider;
import org.killbill.billing.util.cache.BaseCacheLoader;
import org.killbill.billing.util.glue.RedisCacheProviderBase;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Redis107CacheManagerProvider
extends RedisCacheProviderBase
implements Provider<CacheManager> {
    private static final Logger logger = LoggerFactory.getLogger(Redis107CacheManagerProvider.class);
    private final Set<BaseCacheLoader> cacheLoaders;

    @Inject
    public Redis107CacheManagerProvider(MetricRegistry metricRegistry, @Named(value="redisCacheClient") RedissonClient redissonClient, Set<BaseCacheLoader> cacheLoaders) {
        super(metricRegistry, redissonClient);
        this.cacheLoaders = cacheLoaders;
    }

    public CacheManager get() {
        CachingProvider cachingProvider = Caching.getCachingProvider((String)"org.redisson.jcache.JCachingProvider");
        CacheManager cacheManager = cachingProvider.getCacheManager();
        for (BaseCacheLoader cacheLoader : this.cacheLoaders) {
            this.createCache(cacheManager, cacheLoader.getCacheType().getCacheName(), cacheLoader.getCacheType().getKeyType(), cacheLoader.getCacheType().getValueType());
        }
        return cacheManager;
    }
}

