/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.glue;

import com.codahale.metrics.MetricRegistry;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import org.killbill.billing.util.glue.CacheProviderBase;
import org.redisson.api.RedissonClient;
import org.redisson.jcache.configuration.RedissonConfiguration;

abstract class RedisCacheProviderBase
extends CacheProviderBase {
    private final RedissonClient redissonClient;

    RedisCacheProviderBase(MetricRegistry metricRegistry, RedissonClient redissonClient) {
        super(metricRegistry);
        this.redissonClient = redissonClient;
    }

    <K, V> void createCache(CacheManager cacheManager, String cacheName, Class<K> keyType, Class<V> valueType) {
        MutableConfiguration jcacheConfig = new MutableConfiguration().setTypes(keyType, valueType);
        Configuration redissonConfiguration = RedissonConfiguration.fromInstance((RedissonClient)this.redissonClient, (Configuration)jcacheConfig);
        this.createCache(cacheManager, cacheName, redissonConfiguration);
    }
}

