/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.glue;

import com.codahale.metrics.MetricRegistry;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.cache.CacheManager;
import org.killbill.billing.util.glue.RedisCacheProviderBase;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisShiroManager
extends RedisCacheProviderBase
implements CacheManager {
    private static final Logger log = LoggerFactory.getLogger(RedisShiroManager.class);
    private final javax.cache.CacheManager eh107CacheManager;

    public RedisShiroManager(javax.cache.CacheManager eh107CacheManager, MetricRegistry metricRegistry, RedissonClient redissonClient) {
        super(metricRegistry, redissonClient);
        this.eh107CacheManager = eh107CacheManager;
    }

    public <K, V> org.apache.shiro.cache.Cache<K, V> getCache(String name) throws CacheException {
        log.trace("Acquiring RedisShiro instance named [{}]", (Object)name);
        Cache cache = this.eh107CacheManager.getCache(name, Object.class, Object.class);
        if (cache == null) {
            log.info("Cache with name {} does not yet exist.  Creating now.", (Object)name);
            this.createCache(this.eh107CacheManager, name, Object.class, Object.class);
            cache = this.eh107CacheManager.getCache(name, Object.class, Object.class);
            log.info("Added RedisShiro named [{}]", (Object)name);
        } else {
            log.info("Using existing RedisShiro named [{}]", (Object)name);
        }
        return new RedisCache(cache);
    }

    private static final class RedisCache<K, V>
    implements org.apache.shiro.cache.Cache<K, V> {
        private final Cache<K, V> cache;

        public RedisCache(Cache cache) {
            this.cache = cache;
        }

        public V get(K key) throws CacheException {
            return (V)this.cache.get(key);
        }

        public V put(K key, V value) throws CacheException {
            Object previousValue;
            while (!((previousValue = this.cache.get(key)) == null ? this.cache.putIfAbsent(key, value) : this.cache.replace(key, value))) {
            }
            return (V)previousValue;
        }

        public V remove(K key) throws CacheException {
            Object previousValue;
            while ((previousValue = this.cache.get(key)) != null && !this.cache.remove(key)) {
            }
            return (V)previousValue;
        }

        public void clear() throws CacheException {
            this.cache.clear();
        }

        public int size() {
            return this.keys().size();
        }

        public Set<K> keys() {
            HashSet<Object> result = new HashSet<Object>();
            for (Cache.Entry entry : this.cache) {
                result.add(entry.getKey());
            }
            return result;
        }

        public Collection<V> values() {
            LinkedList<Object> result = new LinkedList<Object>();
            for (Cache.Entry entry : this.cache) {
                result.add(entry.getValue());
            }
            return result;
        }
    }
}

