/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.glue;

import com.codahale.metrics.MetricRegistry;
import com.google.inject.name.Named;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SubjectDAO;
import org.killbill.billing.util.glue.RedisShiroManager;
import org.redisson.api.RedissonClient;

public class RedisShiroManagerProvider
implements Provider<RedisShiroManager> {
    private final SecurityManager securityManager;
    private final SubjectDAO subjectDAO;
    private final javax.cache.CacheManager eh107CacheManager;
    private final MetricRegistry metricRegistry;
    private final RedissonClient redissonClient;

    @Inject
    public RedisShiroManagerProvider(SecurityManager securityManager, SubjectDAO subjectDAO, javax.cache.CacheManager eh107CacheManager, MetricRegistry metricRegistry, @Named(value="redisCacheClient") RedissonClient redissonClient) {
        this.securityManager = securityManager;
        this.subjectDAO = subjectDAO;
        this.eh107CacheManager = eh107CacheManager;
        this.metricRegistry = metricRegistry;
        this.redissonClient = redissonClient;
    }

    public RedisShiroManager get() {
        RedisShiroManager shiroRedisManager = new RedisShiroManager(this.eh107CacheManager, this.metricRegistry, this.redissonClient);
        if (this.securityManager instanceof DefaultSecurityManager) {
            DefaultSecurityManager securityManager = (DefaultSecurityManager)this.securityManager;
            securityManager.setCacheManager((CacheManager)shiroRedisManager);
            securityManager.setSubjectDAO(this.subjectDAO);
        }
        return shiroRedisManager;
    }
}

