/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.glue;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Provider;
import javax.inject.Inject;
import org.killbill.billing.util.config.definition.RedisCacheConfig;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.SerializationCodec;
import org.redisson.config.Config;

public class RedissonCacheClientProvider
implements Provider<RedissonClient> {
    private final String address;
    private final int connectionMinimumIdleSize;

    @Inject
    public RedissonCacheClientProvider(RedisCacheConfig cacheConfig) {
        this(cacheConfig.getUrl(), cacheConfig.getConnectionMinimumIdleSize());
    }

    @VisibleForTesting
    public RedissonCacheClientProvider(String address, int connectionMinimumIdleSize) {
        this.address = address;
        this.connectionMinimumIdleSize = connectionMinimumIdleSize;
    }

    public RedissonClient get() {
        SerializationCodec codec = new SerializationCodec();
        Config redissonCfg = new Config();
        redissonCfg.setCodec((Codec)codec).useSingleServer().setAddress(this.address).setConnectionMinimumIdleSize(this.connectionMinimumIdleSize);
        return Redisson.create((Config)redissonCfg);
    }
}

