/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.glue;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.eis.CachingSessionDAO;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.killbill.billing.util.config.definition.RbacConfig;
import org.killbill.billing.util.config.definition.RedisCacheConfig;
import org.killbill.billing.util.security.shiro.dao.JDBCSessionDao;
import org.killbill.billing.util.security.shiro.dao.RedisSessionDao;
import org.skife.jdbi.v2.IDBI;

public class SessionDAOProvider
implements Provider<SessionDAO> {
    private final SessionManager sessionManager;
    private final IDBI dbi;
    private final IDBI roDbi;
    private final RbacConfig rbacConfig;
    private final RedisCacheConfig redisCacheConfig;

    @Inject
    public SessionDAOProvider(IDBI dbi, @Named(value="main-ro") IDBI roDbi, SessionManager sessionManager, RbacConfig rbacConfig, RedisCacheConfig redisCacheConfig) {
        this.sessionManager = sessionManager;
        this.dbi = dbi;
        this.roDbi = roDbi;
        this.rbacConfig = rbacConfig;
        this.redisCacheConfig = redisCacheConfig;
    }

    public SessionDAO get() {
        CachingSessionDAO sessionDao = this.redisCacheConfig.isRedisCachingEnabled() ? new RedisSessionDao() : new JDBCSessionDao(this.dbi, this.roDbi);
        if (this.sessionManager instanceof DefaultSessionManager) {
            DefaultSessionManager defaultSessionManager = (DefaultSessionManager)this.sessionManager;
            defaultSessionManager.setSessionDAO((SessionDAO)sessionDao);
            defaultSessionManager.setGlobalSessionTimeout(this.rbacConfig.getGlobalSessionTimeout().getMillis());
        }
        return sessionDao;
    }
}

