/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.nodes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.List;
import org.killbill.CreatorName;
import org.killbill.billing.broadcast.BroadcastApi;
import org.killbill.billing.osgi.api.PluginInfo;
import org.killbill.billing.platform.api.KillbillService;
import org.killbill.billing.util.nodes.DefaultNodeInfo;
import org.killbill.billing.util.nodes.KillbillNodesApi;
import org.killbill.billing.util.nodes.NodeCommand;
import org.killbill.billing.util.nodes.NodeInfo;
import org.killbill.billing.util.nodes.NodeInfoMapper;
import org.killbill.billing.util.nodes.dao.NodeInfoDao;
import org.killbill.billing.util.nodes.dao.NodeInfoModelDao;
import org.killbill.billing.util.nodes.json.NodeInfoModelJson;
import org.killbill.billing.util.nodes.json.PluginInfoModelJson;
import org.killbill.clock.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKillbillNodesApi
implements KillbillNodesApi {
    private final Logger logger = LoggerFactory.getLogger(DefaultKillbillNodesApi.class);
    private final NodeInfoDao nodeInfoDao;
    private final BroadcastApi broadcastApi;
    private final NodeInfoMapper mapper;
    private final Clock clock;
    private final Function<NodeInfoModelDao, NodeInfo> nodeTransfomer;

    @Inject
    public DefaultKillbillNodesApi(NodeInfoDao nodeInfoDao, BroadcastApi broadcastApi, final NodeInfoMapper mapper, Clock clock) {
        this.nodeInfoDao = nodeInfoDao;
        this.broadcastApi = broadcastApi;
        this.clock = clock;
        this.mapper = mapper;
        this.nodeTransfomer = new Function<NodeInfoModelDao, NodeInfo>(){

            public NodeInfo apply(NodeInfoModelDao input) {
                try {
                    NodeInfoModelJson nodeInfoModelJson = mapper.deserializeNodeInfo(input.getNodeInfo());
                    return new DefaultNodeInfo(nodeInfoModelJson);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public Iterable<NodeInfo> getNodesInfo() {
        List<NodeInfoModelDao> allNodes = this.nodeInfoDao.getAll();
        return Iterables.transform(allNodes, this.nodeTransfomer);
    }

    public NodeInfo getCurrentNodeInfo() {
        List<NodeInfoModelDao> allNodes = this.nodeInfoDao.getAll();
        NodeInfoModelDao current = (NodeInfoModelDao)Iterables.find(allNodes, (Predicate)new Predicate<NodeInfoModelDao>(){

            public boolean apply(NodeInfoModelDao input) {
                return input.getNodeName().equals(CreatorName.get());
            }
        });
        return (NodeInfo)this.nodeTransfomer.apply((Object)current);
    }

    public void triggerNodeCommand(NodeCommand nodeCommand, boolean localNodeOnly) {
        try {
            String event = this.mapper.serializeNodeCommand(nodeCommand.getNodeCommandMetadata());
            this.broadcastApi.broadcast(KillbillService.KILLBILL_SERVICES.BROADCAST_SERVICE.getServiceName(), nodeCommand.getNodeCommandType(), event, this.clock.getUTCNow(), "unset", localNodeOnly);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void notifyPluginChanged(PluginInfo plugin, Iterable<PluginInfo> latestPlugins) {
        try {
            String updatedNodeInfoJson = this.computeLatestNodeInfo(latestPlugins);
            this.nodeInfoDao.updateNodeInfo(CreatorName.get(), updatedNodeInfoJson);
        }
        catch (IOException e) {
            this.logger.warn("Failed to update nodeInfo after plugin change", (Throwable)e);
        }
    }

    private String computeLatestNodeInfo(Iterable<PluginInfo> rawPluginInfo) throws IOException {
        NodeInfoModelDao nodeInfo = this.nodeInfoDao.getByNodeName(CreatorName.get());
        NodeInfoModelJson nodeInfoJson = this.mapper.deserializeNodeInfo(nodeInfo.getNodeInfo());
        ImmutableList pluginInfos = rawPluginInfo.iterator().hasNext() ? ImmutableList.copyOf(rawPluginInfo) : ImmutableList.of();
        NodeInfoModelJson updatedNodeInfoJson = new NodeInfoModelJson(CreatorName.get(), nodeInfoJson.getBootTime(), this.clock.getUTCNow(), nodeInfoJson.getKillbillVersion(), nodeInfoJson.getApiVersion(), nodeInfoJson.getPluginApiVersion(), nodeInfoJson.getCommonVersion(), nodeInfoJson.getPlatformVersion(), (List<PluginInfoModelJson>)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)pluginInfos, (Function)new Function<PluginInfo, PluginInfoModelJson>(){

            public PluginInfoModelJson apply(PluginInfo input) {
                return new PluginInfoModelJson(input);
            }
        })));
        String nodeInfoValue = this.mapper.serializeNodeInfo(updatedNodeInfoJson);
        return nodeInfoValue;
    }
}

