/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.nodes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.killbill.CreatorName;
import org.killbill.billing.osgi.api.PluginInfo;
import org.killbill.billing.osgi.api.PluginsInfoApi;
import org.killbill.billing.platform.api.KillbillService;
import org.killbill.billing.platform.api.LifecycleHandlerType;
import org.killbill.billing.util.nodes.KillbillNodesApi;
import org.killbill.billing.util.nodes.KillbillNodesService;
import org.killbill.billing.util.nodes.KillbillVersions;
import org.killbill.billing.util.nodes.NodeInfoMapper;
import org.killbill.billing.util.nodes.dao.NodeInfoDao;
import org.killbill.billing.util.nodes.dao.NodeInfoModelDao;
import org.killbill.billing.util.nodes.json.NodeInfoModelJson;
import org.killbill.billing.util.nodes.json.PluginInfoModelJson;
import org.killbill.clock.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKillbillNodesService
implements KillbillNodesService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultKillbillNodesService.class);
    private final NodeInfoDao nodeInfoDao;
    private final PluginsInfoApi pluginInfoApi;
    private final Clock clock;
    private final NodeInfoMapper mapper;
    private final KillbillNodesApi nodesApi;

    @Inject
    public DefaultKillbillNodesService(NodeInfoDao nodeInfoDao, PluginsInfoApi pluginInfoApi, KillbillNodesApi nodesApi, Clock clock, NodeInfoMapper mapper) {
        this.nodeInfoDao = nodeInfoDao;
        this.pluginInfoApi = pluginInfoApi;
        this.nodesApi = nodesApi;
        this.clock = clock;
        this.mapper = mapper;
    }

    public String getName() {
        return KillbillService.KILLBILL_SERVICES.NODES_SERVICE.getServiceName();
    }

    public int getRegistrationOrdering() {
        return KillbillService.KILLBILL_SERVICES.NODES_SERVICE.getRegistrationOrdering();
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.BOOT)
    public void init() {
        try {
            this.createBootNodeInfo(true);
        }
        catch (JsonProcessingException e) {
            logger.error("Failed to create bootNodeInfo", (Throwable)e);
        }
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.START_SERVICE)
    public void start() {
        try {
            this.createBootNodeInfo(false);
        }
        catch (JsonProcessingException e) {
            logger.error("Failed to create bootNodeInfo", (Throwable)e);
        }
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.STOP_SERVICE)
    public void stop() {
        this.nodeInfoDao.delete(CreatorName.get());
    }

    private void createBootNodeInfo(boolean skipPlugins) throws JsonProcessingException {
        DateTime bootTime = this.clock.getUTCNow();
        ImmutableList rawPluginInfo = skipPlugins ? ImmutableList.of() : this.pluginInfoApi.getPluginsInfo();
        ImmutableList pluginInfo = rawPluginInfo.iterator().hasNext() ? ImmutableList.copyOf((Iterable)rawPluginInfo) : ImmutableList.of();
        String kbVersion = KillbillVersions.getKillbillVersion();
        String kbApiVersion = KillbillVersions.getApiVersion();
        String kbPluginApiVersion = KillbillVersions.getPluginApiVersion();
        String kbPlatformVersion = KillbillVersions.getPlatformVersion();
        String kbCommonVersion = KillbillVersions.getCommonVersion();
        NodeInfoModelJson nodeInfo = new NodeInfoModelJson(CreatorName.get(), bootTime, bootTime, kbVersion, kbApiVersion, kbPluginApiVersion, kbCommonVersion, kbPlatformVersion, (List<PluginInfoModelJson>)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)pluginInfo, (Function)new Function<PluginInfo, PluginInfoModelJson>(){

            public PluginInfoModelJson apply(PluginInfo input) {
                return new PluginInfoModelJson(input);
            }
        })));
        String nodeInfoValue = this.mapper.serializeNodeInfo(nodeInfo);
        NodeInfoModelDao bootNodeInfo = new NodeInfoModelDao(CreatorName.get(), this.clock.getUTCNow(), nodeInfoValue);
        this.nodeInfoDao.create(bootNodeInfo);
    }
}

