/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.nodes;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.killbill.billing.osgi.api.DefaultPluginsInfoApi;
import org.killbill.billing.osgi.api.PluginInfo;
import org.killbill.billing.osgi.api.PluginServiceInfo;
import org.killbill.billing.util.nodes.NodeInfo;
import org.killbill.billing.util.nodes.json.NodeInfoModelJson;
import org.killbill.billing.util.nodes.json.PluginInfoModelJson;
import org.killbill.billing.util.nodes.json.PluginServiceInfoModelJson;

public class DefaultNodeInfo
implements NodeInfo {
    private final String nodeName;
    private final DateTime bootTime;
    private final DateTime lastUpdatedDate;
    private final String killbillVersion;
    private final String apiVersion;
    private final String platformVersion;
    private final String commonVersion;
    private final String pluginApiVersion;
    private final Iterable<PluginInfo> pluginInfo;

    public DefaultNodeInfo(String nodeName, DateTime bootTime, DateTime lastUpdatedDate, String killbillVersion, String apiVersion, String platformVersion, String commonVersion, String pluginApiVersion, Iterable<PluginInfo> pluginInfo) {
        this.nodeName = nodeName;
        this.bootTime = bootTime;
        this.lastUpdatedDate = lastUpdatedDate;
        this.killbillVersion = killbillVersion;
        this.apiVersion = apiVersion;
        this.platformVersion = platformVersion;
        this.commonVersion = commonVersion;
        this.pluginApiVersion = pluginApiVersion;
        this.pluginInfo = pluginInfo;
    }

    public DefaultNodeInfo(NodeInfoModelJson in) {
        this(in.getNodeName(), in.getBootTime(), in.getBootTime(), in.getKillbillVersion(), in.getApiVersion(), in.getPlatformVersion(), in.getCommonVersion(), in.getPluginApiVersion(), DefaultNodeInfo.toPluginInfo(in.getPluginInfo()));
    }

    private static Set<PluginServiceInfo> toPluginServiceInfo(Set<PluginServiceInfoModelJson> services) {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(services, (Function)new Function<PluginServiceInfoModelJson, PluginServiceInfo>(){

            @Nullable
            public PluginServiceInfo apply(PluginServiceInfoModelJson input) {
                return new DefaultPluginsInfoApi.DefaultPluginServiceInfo(input.getServiceTypeName(), input.getRegistrationName());
            }
        }));
    }

    private static Iterable<PluginInfo> toPluginInfo(Iterable<PluginInfoModelJson> plugins) {
        return Iterables.transform(plugins, (Function)new Function<PluginInfoModelJson, PluginInfo>(){

            public PluginInfo apply(PluginInfoModelJson input) {
                return new DefaultPluginsInfoApi.DefaultPluginInfo(input.getPluginKey(), input.getBundleSymbolicName(), input.getPluginName(), input.getVersion(), input.getState(), input.isSelectedForStart(), DefaultNodeInfo.toPluginServiceInfo(input.getServices()));
            }
        });
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public DateTime getBootTime() {
        return this.bootTime;
    }

    public DateTime getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public String getKillbillVersion() {
        return this.killbillVersion;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public String getCommonVersion() {
        return this.commonVersion;
    }

    public String getPluginApiVersion() {
        return this.pluginApiVersion;
    }

    public Iterable<PluginInfo> getPluginInfo() {
        return this.pluginInfo;
    }
}

