/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.nodes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import javax.inject.Inject;
import org.killbill.billing.util.nodes.DefaultNodeCommandMetadata;
import org.killbill.billing.util.nodes.NodeCommandMetadata;
import org.killbill.billing.util.nodes.SystemNodeCommandType;
import org.killbill.billing.util.nodes.json.NodeInfoModelJson;

public class NodeInfoMapper {
    private final ObjectMapper mapper = new ObjectMapper();

    @Inject
    public NodeInfoMapper() {
        this.mapper.registerModule((Module)new JodaModule());
        this.mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    public String serializeNodeInfo(NodeInfoModelJson nodeInfo) throws JsonProcessingException {
        return this.mapper.writeValueAsString((Object)nodeInfo);
    }

    public NodeInfoModelJson deserializeNodeInfo(String nodeInfo) throws IOException {
        return (NodeInfoModelJson)this.mapper.readValue(nodeInfo, NodeInfoModelJson.class);
    }

    public String serializeNodeCommand(NodeCommandMetadata nodeCommandMetadata) throws JsonProcessingException {
        return this.mapper.writeValueAsString((Object)nodeCommandMetadata);
    }

    public NodeCommandMetadata deserializeNodeCommand(String nodeCommand, final String type) throws IOException {
        SystemNodeCommandType systemType = (SystemNodeCommandType)Iterables.tryFind((Iterable)ImmutableList.copyOf((Object[])SystemNodeCommandType.values()), (Predicate)new Predicate<SystemNodeCommandType>(){

            public boolean apply(SystemNodeCommandType input) {
                return input.name().equals(type);
            }
        }).orNull();
        return systemType != null ? (NodeCommandMetadata)this.mapper.readValue(nodeCommand, systemType.getCommandMetadataClass()) : (NodeCommandMetadata)this.mapper.readValue(nodeCommand, DefaultNodeCommandMetadata.class);
    }
}

