/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.nodes.dao;

import com.google.inject.Inject;
import java.util.Date;
import java.util.List;
import javax.inject.Named;
import org.killbill.billing.util.entity.dao.DBRouter;
import org.killbill.billing.util.nodes.dao.NodeInfoDao;
import org.killbill.billing.util.nodes.dao.NodeInfoModelDao;
import org.killbill.billing.util.nodes.dao.NodeInfoSqlDao;
import org.killbill.clock.Clock;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;

public class DefaultNodeInfoDao
implements NodeInfoDao {
    private final DBRouter<NodeInfoSqlDao> dbRouter;
    private final Clock clock;

    @Inject
    public DefaultNodeInfoDao(IDBI dbi, @Named(value="main-ro") IDBI roDbi, Clock clock) {
        this.dbRouter = new DBRouter<NodeInfoSqlDao>(dbi, roDbi, NodeInfoSqlDao.class);
        this.clock = clock;
    }

    @Override
    public void create(final NodeInfoModelDao nodeInfoModelDao) {
        this.dbRouter.inTransaction(false, new TransactionCallback<Void>(){

            public Void inTransaction(Handle handle, TransactionStatus status) throws Exception {
                NodeInfoSqlDao sqlDao = (NodeInfoSqlDao)handle.attach(NodeInfoSqlDao.class);
                if (sqlDao.getByNodeName(nodeInfoModelDao.getNodeName()) != null) {
                    sqlDao.delete(nodeInfoModelDao.getNodeName());
                }
                sqlDao.create(nodeInfoModelDao);
                return null;
            }
        });
    }

    @Override
    public void updateNodeInfo(final String nodeName, final String nodeInfo) {
        this.dbRouter.inTransaction(false, new TransactionCallback<Void>(){

            public Void inTransaction(Handle handle, TransactionStatus status) throws Exception {
                NodeInfoSqlDao sqlDao = (NodeInfoSqlDao)handle.attach(NodeInfoSqlDao.class);
                Date updateDate = DefaultNodeInfoDao.this.clock.getUTCNow().toDate();
                sqlDao.updateNodeInfo(nodeName, nodeInfo, updateDate);
                return null;
            }
        });
    }

    @Override
    public void delete(final String nodeName) {
        this.dbRouter.inTransaction(false, new TransactionCallback<Void>(){

            public Void inTransaction(Handle handle, TransactionStatus status) throws Exception {
                NodeInfoSqlDao sqlDao = (NodeInfoSqlDao)handle.attach(NodeInfoSqlDao.class);
                sqlDao.delete(nodeName);
                return null;
            }
        });
    }

    @Override
    public List<NodeInfoModelDao> getAll() {
        return this.dbRouter.inTransaction(true, new TransactionCallback<List<NodeInfoModelDao>>(){

            public List<NodeInfoModelDao> inTransaction(Handle handle, TransactionStatus status) throws Exception {
                NodeInfoSqlDao sqlDao = (NodeInfoSqlDao)handle.attach(NodeInfoSqlDao.class);
                return sqlDao.getAll();
            }
        });
    }

    @Override
    public NodeInfoModelDao getByNodeName(final String nodeName) {
        return this.dbRouter.inTransaction(true, new TransactionCallback<NodeInfoModelDao>(){

            public NodeInfoModelDao inTransaction(Handle handle, TransactionStatus status) throws Exception {
                NodeInfoSqlDao sqlDao = (NodeInfoSqlDao)handle.attach(NodeInfoSqlDao.class);
                return sqlDao.getByNodeName(nodeName);
            }
        });
    }
}

