/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.security;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.shiro.aop.AnnotationResolver;
import org.apache.shiro.aop.MethodInvocation;

public class AnnotationHierarchicalResolver
implements AnnotationResolver {
    private final Map<String, Annotation> methodToAnnotation = new HashMap<String, Annotation>();
    private static final Map<Class<?>, Boolean> annotatedInterfaceCache = new WeakHashMap();

    public Annotation getAnnotation(MethodInvocation mi, Class<? extends Annotation> clazz) {
        return this.getAnnotationFromMethod(mi.getMethod(), clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Annotation getAnnotationFromMethod(Method method, Class<? extends Annotation> clazz) {
        String key = method.toString();
        Annotation annotation = this.methodToAnnotation.get(key);
        if (annotation == null) {
            Map<String, Annotation> map = this.methodToAnnotation;
            synchronized (map) {
                annotation = this.methodToAnnotation.get(key);
                if (annotation == null) {
                    annotation = AnnotationHierarchicalResolver.findAnnotation(method, clazz);
                    this.methodToAnnotation.put(key, annotation);
                }
            }
        }
        return annotation;
    }

    public static <A extends Annotation> A findAnnotation(Method method, Class<A> annotationType) {
        A annotation = AnnotationHierarchicalResolver.getAnnotation(method, annotationType);
        Class<?> cl = method.getDeclaringClass();
        if (annotation == null) {
            annotation = AnnotationHierarchicalResolver.searchOnInterfaces(method, annotationType, cl.getInterfaces());
        }
        while (annotation == null && (cl = cl.getSuperclass()) != null && cl != Object.class) {
            try {
                Method equivalentMethod = cl.getDeclaredMethod(method.getName(), method.getParameterTypes());
                annotation = AnnotationHierarchicalResolver.getAnnotation(equivalentMethod, annotationType);
                if (annotation != null) continue;
                annotation = AnnotationHierarchicalResolver.searchOnInterfaces(method, annotationType, cl.getInterfaces());
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return annotation;
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationType) {
        A ann = method.getAnnotation(annotationType);
        if (ann == null) {
            Annotation metaAnn;
            Annotation[] annotationArray = method.getAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n && (ann = (metaAnn = annotationArray[i]).annotationType().getAnnotation(annotationType)) == null; ++i) {
            }
        }
        return ann;
    }

    private static <A extends Annotation> A searchOnInterfaces(Method method, Class<A> annotationType, Class<?>[] ifcs) {
        A annotation = null;
        for (Class<?> iface : ifcs) {
            if (!AnnotationHierarchicalResolver.isInterfaceWithAnnotatedMethods(iface)) continue;
            try {
                Method equivalentMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                annotation = AnnotationHierarchicalResolver.getAnnotation(equivalentMethod, annotationType);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (annotation != null) break;
        }
        return annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isInterfaceWithAnnotatedMethods(Class<?> iface) {
        Map<Class<?>, Boolean> map = annotatedInterfaceCache;
        synchronized (map) {
            Boolean flag = annotatedInterfaceCache.get(iface);
            if (flag != null) {
                return flag;
            }
            boolean found = false;
            for (Method ifcMethod : iface.getMethods()) {
                if (ifcMethod.getAnnotations().length <= 0) continue;
                found = true;
                break;
            }
            annotatedInterfaceCache.put(iface, found);
            return found;
        }
    }
}

