/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.security;

import org.apache.shiro.aop.AnnotationResolver;
import org.apache.shiro.aop.MethodInvocation;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.aop.AuthorizingAnnotationHandler;
import org.apache.shiro.authz.aop.AuthorizingAnnotationMethodInterceptor;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.CallOrigin;
import org.killbill.billing.util.callcontext.UserType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionAnnotationMethodInterceptor
extends AuthorizingAnnotationMethodInterceptor {
    private static final String SKIP_AUTH_FOR_PLUGINS = "org.killbill.security.skipAuthForPlugins";
    private static final Logger logger = LoggerFactory.getLogger(PermissionAnnotationMethodInterceptor.class);
    private final KillbillConfigSource killbillConfigSource;

    public PermissionAnnotationMethodInterceptor(KillbillConfigSource killbillConfigSource, AuthorizingAnnotationHandler handler, AnnotationResolver resolver) {
        super(handler, resolver);
        this.killbillConfigSource = killbillConfigSource;
    }

    public void assertAuthorized(MethodInvocation mi) throws AuthorizationException {
        if (this.shouldSkipAuthForPlugins(mi)) {
            return;
        }
        try {
            ((AuthorizingAnnotationHandler)this.getHandler()).assertAuthorized(this.getAnnotation(mi));
        }
        catch (AuthorizationException ae) {
            if (ae.getCause() == null) {
                ae.initCause((Throwable)new AuthorizationException("Not authorized to invoke method: " + mi.getMethod()));
            }
            throw ae;
        }
    }

    private boolean shouldSkipAuthForPlugins(MethodInvocation mi) {
        if (!Boolean.parseBoolean(this.killbillConfigSource.getString(SKIP_AUTH_FOR_PLUGINS))) {
            return false;
        }
        Object[] arguments = mi.getArguments();
        for (int i = arguments.length - 1; i >= 0; --i) {
            CallContext callContext;
            Object argument = arguments[i];
            if (!(argument instanceof CallContext) || (callContext = (CallContext)argument).getCallOrigin() != CallOrigin.INTERNAL || callContext.getUserType() != UserType.ADMIN) continue;
            logger.debug("Skipping authorization check for userName={}, userToken={}", (Object)callContext.getUserName(), (Object)callContext.getUserToken());
            return true;
        }
        return false;
    }
}

