/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.security.shiro;

import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.killbill.billing.util.config.definition.SecurityConfig;

public class KillbillCredentialsMatcher {
    public static final String HASH_ALGORITHM_NAME = "SHA-512";

    private KillbillCredentialsMatcher() {
    }

    public static CredentialsMatcher getCredentialsMatcher(SecurityConfig securityConfig) {
        HashedCredentialsMatcher credentialsMatcher = new HashedCredentialsMatcher(HASH_ALGORITHM_NAME);
        credentialsMatcher.setStoredCredentialsHexEncoded(false);
        credentialsMatcher.setHashIterations(securityConfig.getShiroNbHashIterations().intValue());
        return credentialsMatcher;
    }
}

