/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.security.shiro.dao;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.shiro.crypto.RandomNumberGenerator;
import org.apache.shiro.crypto.SecureRandomNumberGenerator;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.apache.shiro.util.ByteSource;
import org.joda.time.DateTime;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.security.SecurityApiException;
import org.killbill.billing.util.config.definition.SecurityConfig;
import org.killbill.billing.util.security.shiro.dao.RolesPermissionsModelDao;
import org.killbill.billing.util.security.shiro.dao.RolesPermissionsSqlDao;
import org.killbill.billing.util.security.shiro.dao.UserDao;
import org.killbill.billing.util.security.shiro.dao.UserModelDao;
import org.killbill.billing.util.security.shiro.dao.UserRolesModelDao;
import org.killbill.billing.util.security.shiro.dao.UserRolesSqlDao;
import org.killbill.billing.util.security.shiro.dao.UsersSqlDao;
import org.killbill.clock.Clock;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;

public class DefaultUserDao
implements UserDao {
    private static final RandomNumberGenerator rng = new SecureRandomNumberGenerator();
    private final IDBI dbi;
    private final Clock clock;
    private final SecurityConfig securityConfig;

    @Inject
    public DefaultUserDao(IDBI dbi, Clock clock, SecurityConfig securityConfig) {
        this.dbi = dbi;
        this.clock = clock;
        this.securityConfig = securityConfig;
    }

    @Override
    public void insertUser(final String username, String password, final List<String> roles, final String createdBy) throws SecurityApiException {
        final ByteSource salt = rng.nextBytes();
        final String hashedPasswordBase64 = new SimpleHash("SHA-512", (Object)password, (Object)salt.toBase64(), this.securityConfig.getShiroNbHashIterations().intValue()).toBase64();
        final DateTime createdDate = this.clock.getUTCNow();
        this.inTransactionWithExceptionHandling(new TransactionCallback<Void>(){

            public Void inTransaction(Handle handle, TransactionStatus status) throws Exception {
                UserRolesSqlDao userRolesSqlDao = (UserRolesSqlDao)handle.attach(UserRolesSqlDao.class);
                for (String role : roles) {
                    userRolesSqlDao.create(new UserRolesModelDao(username, role, createdDate, createdBy));
                }
                UsersSqlDao usersSqlDao = (UsersSqlDao)handle.attach(UsersSqlDao.class);
                UserModelDao userModelDao = usersSqlDao.getByUsername(username);
                if (userModelDao != null) {
                    throw new SecurityApiException(ErrorCode.SECURITY_USER_ALREADY_EXISTS, new Object[]{username});
                }
                usersSqlDao.create(new UserModelDao(username, hashedPasswordBase64, salt.toBase64(), createdDate, createdBy));
                return null;
            }
        });
    }

    @Override
    public List<UserRolesModelDao> getUserRoles(final String username) throws SecurityApiException {
        return this.inTransactionWithExceptionHandling(new TransactionCallback<List<UserRolesModelDao>>(){

            public List<UserRolesModelDao> inTransaction(Handle handle, TransactionStatus status) throws Exception {
                UsersSqlDao usersSqlDao = (UsersSqlDao)handle.attach(UsersSqlDao.class);
                UserModelDao userModelDao = usersSqlDao.getByUsername(username);
                if (userModelDao == null) {
                    throw new SecurityApiException(ErrorCode.SECURITY_INVALID_USER, new Object[]{username});
                }
                UserRolesSqlDao userRolesSqlDao = (UserRolesSqlDao)handle.attach(UserRolesSqlDao.class);
                return userRolesSqlDao.getByUsername(username);
            }
        });
    }

    @Override
    public void addRoleDefinition(final String role, final List<String> permissions, final String createdBy) throws SecurityApiException {
        final DateTime createdDate = this.clock.getUTCNow();
        this.inTransactionWithExceptionHandling(new TransactionCallback<Void>(){

            public Void inTransaction(Handle handle, TransactionStatus status) throws Exception {
                RolesPermissionsSqlDao rolesPermissionsSqlDao = (RolesPermissionsSqlDao)handle.attach(RolesPermissionsSqlDao.class);
                List<RolesPermissionsModelDao> existingRole = rolesPermissionsSqlDao.getByRoleName(role);
                if (!existingRole.isEmpty()) {
                    throw new SecurityApiException(ErrorCode.SECURITY_ROLE_ALREADY_EXISTS, new Object[]{role});
                }
                for (String permission : permissions) {
                    rolesPermissionsSqlDao.create(new RolesPermissionsModelDao(role, permission, createdDate, createdBy));
                }
                return null;
            }
        });
    }

    @Override
    public void updateRoleDefinition(final String role, final List<String> permissions, final String createdBy) throws SecurityApiException {
        final DateTime createdDate = this.clock.getUTCNow();
        this.inTransactionWithExceptionHandling(new TransactionCallback<Void>(){

            public Void inTransaction(Handle handle, TransactionStatus status) throws Exception {
                RolesPermissionsSqlDao rolesPermissionsSqlDao = (RolesPermissionsSqlDao)handle.attach(RolesPermissionsSqlDao.class);
                final List<RolesPermissionsModelDao> existingPermissions = rolesPermissionsSqlDao.getByRoleName(role);
                List<RolesPermissionsModelDao> toBeDeleted = existingPermissions.isEmpty() ? existingPermissions : Iterables.filter(existingPermissions, (Predicate)new Predicate<RolesPermissionsModelDao>(){

                    public boolean apply(RolesPermissionsModelDao input) {
                        return !permissions.contains(input.getPermission());
                    }
                });
                Iterable toBeAdded = Iterables.filter((Iterable)permissions, (Predicate)new Predicate<String>(){

                    public boolean apply(String input) {
                        for (RolesPermissionsModelDao e : existingPermissions) {
                            if (!e.getPermission().equals(input)) continue;
                            return false;
                        }
                        return true;
                    }
                });
                for (RolesPermissionsModelDao d : toBeDeleted) {
                    rolesPermissionsSqlDao.unactiveEvent(d.getRecordId(), createdDate, createdBy);
                }
                for (String permission : toBeAdded) {
                    rolesPermissionsSqlDao.create(new RolesPermissionsModelDao(role, permission, createdDate, createdBy));
                }
                return null;
            }
        });
    }

    @Override
    public List<RolesPermissionsModelDao> getRoleDefinition(final String role) {
        return (List)this.dbi.inTransaction((TransactionCallback)new TransactionCallback<List<RolesPermissionsModelDao>>(){

            public List<RolesPermissionsModelDao> inTransaction(Handle handle, TransactionStatus status) throws Exception {
                RolesPermissionsSqlDao rolesPermissionsSqlDao = (RolesPermissionsSqlDao)handle.attach(RolesPermissionsSqlDao.class);
                return rolesPermissionsSqlDao.getByRoleName(role);
            }
        });
    }

    @Override
    public Set<String> getAllPermissions() {
        return (Set)this.dbi.inTransaction((TransactionCallback)new TransactionCallback<Set<String>>(){

            public Set<String> inTransaction(Handle handle, TransactionStatus status) throws Exception {
                RolesPermissionsSqlDao rolesPermissionsSqlDao = (RolesPermissionsSqlDao)handle.attach(RolesPermissionsSqlDao.class);
                return rolesPermissionsSqlDao.getAllPermissions();
            }
        });
    }

    @Override
    public void updateUserPassword(final String username, String password, final String updatedBy) throws SecurityApiException {
        final ByteSource salt = rng.nextBytes();
        final String hashedPasswordBase64 = new SimpleHash("SHA-512", (Object)password, (Object)salt.toBase64(), this.securityConfig.getShiroNbHashIterations().intValue()).toBase64();
        this.inTransactionWithExceptionHandling(new TransactionCallback<Void>(){

            public Void inTransaction(Handle handle, TransactionStatus status) throws Exception {
                DateTime updatedDate = DefaultUserDao.this.clock.getUTCNow();
                UsersSqlDao usersSqlDao = (UsersSqlDao)handle.attach(UsersSqlDao.class);
                UserModelDao userModelDao = usersSqlDao.getByUsername(username);
                if (userModelDao == null) {
                    throw new SecurityApiException(ErrorCode.SECURITY_INVALID_USER, new Object[]{username});
                }
                usersSqlDao.updatePassword(username, hashedPasswordBase64, salt.toBase64(), updatedDate.toDate(), updatedBy);
                return null;
            }
        });
    }

    @Override
    public void updateUserRoles(final String username, final List<String> roles, final String updatedBy) throws SecurityApiException {
        this.inTransactionWithExceptionHandling(new TransactionCallback<Void>(){

            public Void inTransaction(Handle handle, TransactionStatus status) throws Exception {
                DateTime updatedDate = DefaultUserDao.this.clock.getUTCNow();
                UsersSqlDao usersSqlDao = (UsersSqlDao)handle.attach(UsersSqlDao.class);
                UserModelDao userModelDao = usersSqlDao.getByUsername(username);
                if (userModelDao == null) {
                    throw new SecurityApiException(ErrorCode.SECURITY_INVALID_USER, new Object[]{username});
                }
                UserRolesSqlDao userRolesSqlDao = (UserRolesSqlDao)handle.attach(UserRolesSqlDao.class);
                List<UserRolesModelDao> existingRoles = userRolesSqlDao.getByUsername(username);
                for (final UserRolesModelDao curRole : existingRoles) {
                    if (Iterables.tryFind((Iterable)roles, (Predicate)new Predicate<String>(){

                        public boolean apply(String input) {
                            return input.equals(curRole.getRoleName());
                        }
                    }).orNull() != null) continue;
                    userRolesSqlDao.invalidate(username, curRole.getRoleName(), updatedDate.toDate(), updatedBy);
                }
                for (final String curNewRole : roles) {
                    if (Iterables.tryFind(existingRoles, (Predicate)new Predicate<UserRolesModelDao>(){

                        public boolean apply(UserRolesModelDao input) {
                            return input.getRoleName().equals(curNewRole);
                        }
                    }).orNull() != null) continue;
                    userRolesSqlDao.create(new UserRolesModelDao(username, curNewRole, updatedDate, updatedBy));
                }
                return null;
            }
        });
    }

    @Override
    public void invalidateUser(final String username, final String updatedBy) throws SecurityApiException {
        this.inTransactionWithExceptionHandling(new TransactionCallback<Void>(){

            public Void inTransaction(Handle handle, TransactionStatus status) throws Exception {
                DateTime updatedDate = DefaultUserDao.this.clock.getUTCNow();
                UsersSqlDao usersSqlDao = (UsersSqlDao)handle.attach(UsersSqlDao.class);
                UserModelDao userModelDao = usersSqlDao.getByUsername(username);
                if (userModelDao == null) {
                    throw new SecurityApiException(ErrorCode.SECURITY_INVALID_USER, new Object[]{username});
                }
                usersSqlDao.invalidate(username, updatedDate.toDate(), updatedBy);
                return null;
            }
        });
    }

    private <T> T inTransactionWithExceptionHandling(TransactionCallback<T> callback) throws SecurityApiException {
        try {
            return (T)this.dbi.inTransaction(callback);
        }
        catch (RuntimeException e) {
            this.throwSecurityApiException(e);
            return null;
        }
    }

    private void throwSecurityApiException(Throwable e) throws SecurityApiException {
        if (e.getCause() != null && e.getCause().getClass().isAssignableFrom(SecurityApiException.class)) {
            throw (SecurityApiException)e.getCause();
        }
        if (e.getCause() == null) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        this.throwSecurityApiException(e.getCause());
    }
}

