/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.security.shiro.dao;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.eis.CachingSessionDAO;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.entity.dao.DBRouter;
import org.killbill.billing.util.security.shiro.dao.JDBCSessionSqlDao;
import org.killbill.billing.util.security.shiro.dao.SessionModelDao;
import org.skife.jdbi.v2.IDBI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCSessionDao
extends CachingSessionDAO {
    private static final Logger log = LoggerFactory.getLogger(JDBCSessionDao.class);
    private final DBRouter<JDBCSessionSqlDao> dbRouter;
    private final Cache<Serializable, Boolean> noUpdateSessionsCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).build();

    @Inject
    public JDBCSessionDao(IDBI dbi, @Named(value="main-ro") IDBI roDbi) {
        this.dbRouter = new DBRouter<JDBCSessionSqlDao>(dbi, roDbi, JDBCSessionSqlDao.class);
    }

    protected void doUpdate(Session session) {
        if (this.shouldUpdateSession(session)) {
            this.dbRouter.onDemand(false).update(new SessionModelDao(session));
        }
    }

    protected void doDelete(Session session) {
        this.dbRouter.onDemand(false).delete(new SessionModelDao(session));
    }

    protected Serializable doCreate(Session session) {
        UUID sessionId = UUIDs.randomUUID();
        String sessionIdAsString = sessionId.toString();
        this.assignSessionId(session, (Serializable)((Object)sessionIdAsString));
        this.dbRouter.onDemand(false).create(new SessionModelDao(session));
        return sessionIdAsString;
    }

    protected Session doReadSession(Serializable sessionId) {
        if (sessionId == null) {
            return null;
        }
        String sessionIdString = sessionId.toString();
        SessionModelDao sessionModelDao = this.dbRouter.onDemand(true).read(sessionIdString);
        if (sessionModelDao == null) {
            return null;
        }
        return this.toSession(sessionModelDao);
    }

    public Collection<Session> getActiveSessions() {
        Collection cachedActiveSessions = super.getActiveSessions();
        List<SessionModelDao> oldActiveSessionsOnDisk = this.dbRouter.onDemand(true).findOldActiveSessions();
        LinkedList<Session> activeSessions = new LinkedList<Session>(cachedActiveSessions);
        for (SessionModelDao sessionModelDao : oldActiveSessionsOnDisk) {
            activeSessions.add(this.toSession(sessionModelDao));
        }
        return activeSessions;
    }

    public void disableUpdatesForSession(Session session) {
        this.noUpdateSessionsCache.put((Object)session.getId(), (Object)Boolean.TRUE);
    }

    public void enableUpdatesForSession(Session session) {
        this.noUpdateSessionsCache.invalidate((Object)session.getId());
        this.doUpdate(session);
    }

    private boolean shouldUpdateSession(Session session) {
        return this.noUpdateSessionsCache.getIfPresent((Object)session.getId()) == Boolean.TRUE ? Boolean.FALSE : Boolean.TRUE;
    }

    private Session toSession(SessionModelDao sessionModelDao) {
        try {
            return sessionModelDao.toSimpleSession();
        }
        catch (IOException e) {
            log.warn("Corrupted cookie", (Throwable)e);
            return null;
        }
    }
}

