/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.security.shiro.dao;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.shiro.io.DefaultSerializer;
import org.apache.shiro.io.Serializer;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.SimpleSession;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class SessionModelDao {
    private final Serializer<Map> serializer = new DefaultSerializer();
    private Long recordId;
    private String id;
    private DateTime startTimestamp;
    private DateTime lastAccessTime;
    private long timeout;
    private String host;
    private byte[] sessionData;

    public SessionModelDao() {
    }

    public SessionModelDao(Session session) {
        this.id = session.getId() == null ? null : session.getId().toString();
        this.startTimestamp = new DateTime((Object)session.getStartTimestamp(), DateTimeZone.UTC);
        this.lastAccessTime = new DateTime((Object)session.getLastAccessTime(), DateTimeZone.UTC);
        this.timeout = session.getTimeout();
        this.host = session.getHost();
        try {
            this.sessionData = this.serializeSessionData(session);
        }
        catch (IOException e) {
            this.sessionData = new byte[0];
        }
    }

    public Session toSimpleSession() throws IOException {
        SimpleSession simpleSession = new SimpleSession();
        if (this.id != null) {
            simpleSession.setId((Serializable)((Object)this.id));
        }
        simpleSession.setStartTimestamp(this.startTimestamp.toDate());
        simpleSession.setLastAccessTime(this.lastAccessTime.toDate());
        simpleSession.setTimeout(this.timeout);
        simpleSession.setHost(this.host);
        Map attributes = (Map)this.serializer.deserialize(this.sessionData);
        simpleSession.setAttributes(attributes);
        return simpleSession;
    }

    public Long getRecordId() {
        return this.recordId;
    }

    public String getId() {
        return this.id;
    }

    public DateTime getStartTimestamp() {
        return this.startTimestamp;
    }

    public DateTime getLastAccessTime() {
        return this.lastAccessTime;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public String getHost() {
        return this.host;
    }

    public byte[] getSessionData() {
        return this.sessionData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SessionModelDao{");
        sb.append("recordId=").append(this.recordId);
        sb.append(", id='").append(this.id).append('\'');
        sb.append(", startTimestamp=").append(this.startTimestamp);
        sb.append(", lastAccessTime=").append(this.lastAccessTime);
        sb.append(", timeout=").append(this.timeout);
        sb.append(", host='").append(this.host).append('\'');
        sb.append(", sessionData=").append(Arrays.toString(this.sessionData));
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionModelDao that = (SessionModelDao)o;
        if (this.timeout != that.timeout) {
            return false;
        }
        if (this.recordId != null ? !this.recordId.equals(that.recordId) : that.recordId != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.startTimestamp != null ? !this.startTimestamp.equals((Object)that.startTimestamp) : that.startTimestamp != null) {
            return false;
        }
        if (this.lastAccessTime != null ? !this.lastAccessTime.equals((Object)that.lastAccessTime) : that.lastAccessTime != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        return Arrays.equals(this.sessionData, that.sessionData);
    }

    public int hashCode() {
        int result = this.recordId != null ? this.recordId.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.startTimestamp != null ? this.startTimestamp.hashCode() : 0);
        result = 31 * result + (this.lastAccessTime != null ? this.lastAccessTime.hashCode() : 0);
        result = 31 * result + (int)(this.timeout ^ this.timeout >>> 32);
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.sessionData);
        return result;
    }

    private byte[] serializeSessionData(Session session) throws IOException {
        HashMap sessionAttributes = new HashMap();
        for (Object key : session.getAttributeKeys()) {
            sessionAttributes.put(key, session.getAttribute(key));
        }
        return this.serializer.serialize(sessionAttributes);
    }
}

