/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.tag;

import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.ObjectType;
import org.killbill.billing.entity.EntityBase;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.tag.Tag;

public class DescriptiveTag
extends EntityBase
implements Tag {
    private final UUID tagDefinitionId;
    private final UUID objectId;
    private final ObjectType objectType;

    public DescriptiveTag(UUID id, UUID tagDefinitionId, ObjectType objectType, UUID objectId, DateTime createdDate) {
        super(id, createdDate, createdDate);
        this.tagDefinitionId = tagDefinitionId;
        this.objectType = objectType;
        this.objectId = objectId;
    }

    public DescriptiveTag(UUID tagDefinitionId, ObjectType objectType, UUID objectId, DateTime createdDate) {
        super(UUIDs.randomUUID(), createdDate, createdDate);
        this.tagDefinitionId = tagDefinitionId;
        this.objectType = objectType;
        this.objectId = objectId;
    }

    public UUID getTagDefinitionId() {
        return this.tagDefinitionId;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public UUID getObjectId() {
        return this.objectId;
    }

    public String toString() {
        return "DescriptiveTag [tagDefinitionId=" + this.tagDefinitionId + ", id=" + this.id + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tagDefinitionId == null ? 0 : this.tagDefinitionId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DescriptiveTag other = (DescriptiveTag)((Object)obj);
        return !(this.tagDefinitionId == null ? other.tagDefinitionId != null : !this.tagDefinitionId.equals(other.tagDefinitionId));
    }
}

