/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.tag.dao;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.inject.Named;
import org.killbill.billing.BillingExceptionBase;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.events.ControlTagCreationInternalEvent;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.audit.AuditLogWithHistory;
import org.killbill.billing.util.audit.ChangeType;
import org.killbill.billing.util.audit.dao.AuditDao;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.dao.TableName;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.entity.dao.DefaultPaginationSqlDaoHelper;
import org.killbill.billing.util.entity.dao.EntityDaoBase;
import org.killbill.billing.util.entity.dao.EntitySqlDao;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionalJdbiWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoWrapperFactory;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.billing.util.tag.Tag;
import org.killbill.billing.util.tag.api.user.TagEventBuilder;
import org.killbill.billing.util.tag.dao.SystemTags;
import org.killbill.billing.util.tag.dao.TagDao;
import org.killbill.billing.util.tag.dao.TagDefinitionModelDao;
import org.killbill.billing.util.tag.dao.TagDefinitionSqlDao;
import org.killbill.billing.util.tag.dao.TagModelDao;
import org.killbill.billing.util.tag.dao.TagSqlDao;
import org.killbill.bus.api.BusEvent;
import org.killbill.bus.api.PersistentBus;
import org.killbill.clock.Clock;
import org.skife.jdbi.v2.IDBI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTagDao
extends EntityDaoBase<TagModelDao, Tag, TagApiException>
implements TagDao {
    private static final Logger log = LoggerFactory.getLogger(DefaultTagDao.class);
    private final TagEventBuilder tagEventBuilder;
    private final PersistentBus bus;
    private final AuditDao auditDao;

    @Inject
    public DefaultTagDao(IDBI dbi, @Named(value="main-ro") IDBI roDbi, TagEventBuilder tagEventBuilder, PersistentBus bus, Clock clock, CacheControllerDispatcher controllerDispatcher, NonEntityDao nonEntityDao, InternalCallContextFactory internalCallContextFactory, AuditDao auditDao) {
        super(nonEntityDao, controllerDispatcher, new EntitySqlDaoTransactionalJdbiWrapper(dbi, roDbi, clock, controllerDispatcher, nonEntityDao, internalCallContextFactory), TagSqlDao.class);
        this.tagEventBuilder = tagEventBuilder;
        this.bus = bus;
        this.auditDao = auditDao;
    }

    @Override
    public List<TagModelDao> getTagsForObject(final UUID objectId, final ObjectType objectType, final boolean includedDeleted, final InternalTenantContext internalTenantContext) {
        return this.transactionalSqlDao.execute(true, new EntitySqlDaoTransactionWrapper<List<TagModelDao>>(){

            @Override
            public List<TagModelDao> inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                TagSqlDao tagSqlDao = entitySqlDaoWrapperFactory.become(TagSqlDao.class);
                if (includedDeleted) {
                    return tagSqlDao.getTagsForObjectIncludedDeleted(objectId, objectType, internalTenantContext);
                }
                return tagSqlDao.getTagsForObject(objectId, objectType, internalTenantContext);
            }
        });
    }

    @Override
    public List<TagModelDao> getTagsForAccountType(final ObjectType objectType, boolean includedDeleted, InternalTenantContext internalTenantContext) {
        List<TagModelDao> allTags = this.getTagsForAccount(includedDeleted, internalTenantContext);
        return ImmutableList.copyOf((Collection)Collections2.filter(allTags, (Predicate)new Predicate<TagModelDao>(){

            public boolean apply(TagModelDao input) {
                return input.getObjectType() == objectType;
            }
        }));
    }

    @Override
    public List<TagModelDao> getTagsForAccount(final boolean includedDeleted, final InternalTenantContext internalTenantContext) {
        return this.transactionalSqlDao.execute(true, new EntitySqlDaoTransactionWrapper<List<TagModelDao>>(){

            @Override
            public List<TagModelDao> inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                TagSqlDao tagSqlDao = entitySqlDaoWrapperFactory.become(TagSqlDao.class);
                if (includedDeleted) {
                    return tagSqlDao.getByAccountRecordIdIncludedDeleted(internalTenantContext);
                }
                return tagSqlDao.getByAccountRecordId(internalTenantContext);
            }
        });
    }

    @Override
    public List<AuditLogWithHistory> getTagAuditLogsWithHistoryForId(final UUID tagId, final AuditLevel auditLevel, final InternalTenantContext context) {
        return this.transactionalSqlDao.execute(true, new EntitySqlDaoTransactionWrapper<List<AuditLogWithHistory>>(){

            @Override
            public List<AuditLogWithHistory> inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) {
                TagSqlDao transactional = entitySqlDaoWrapperFactory.become(TagSqlDao.class);
                return DefaultTagDao.this.auditDao.getAuditLogsWithHistoryForId(transactional, TableName.TAG, tagId, auditLevel, context);
            }
        });
    }

    @Override
    protected void postBusEventFromTransaction(TagModelDao tag, TagModelDao savedTag, ChangeType changeType, EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory, InternalCallContext context) throws BillingExceptionBase {
        ControlTagCreationInternalEvent tagEvent;
        TagDefinitionModelDao tagDefinition = this.getTagDefinitionFromTransaction(tag.getTagDefinitionId(), entitySqlDaoWrapperFactory, (InternalTenantContext)context);
        boolean isControlTag = ControlTagType.getTypeFromId((UUID)tagDefinition.getId()) != null;
        switch (changeType) {
            case INSERT: {
                tagEvent = isControlTag ? this.tagEventBuilder.newControlTagCreationEvent(tag.getId(), tag.getObjectId(), tag.getObjectType(), tagDefinition, context.getAccountRecordId(), context.getTenantRecordId(), context.getUserToken()) : this.tagEventBuilder.newUserTagCreationEvent(tag.getId(), tag.getObjectId(), tag.getObjectType(), tagDefinition, context.getAccountRecordId(), context.getTenantRecordId(), context.getUserToken());
                break;
            }
            case DELETE: {
                tagEvent = isControlTag ? this.tagEventBuilder.newControlTagDeletionEvent(tag.getId(), tag.getObjectId(), tag.getObjectType(), tagDefinition, context.getAccountRecordId(), context.getTenantRecordId(), context.getUserToken()) : this.tagEventBuilder.newUserTagDeletionEvent(tag.getId(), tag.getObjectId(), tag.getObjectType(), tagDefinition, context.getAccountRecordId(), context.getTenantRecordId(), context.getUserToken());
                break;
            }
            default: {
                return;
            }
        }
        try {
            this.bus.postFromTransaction((BusEvent)tagEvent, entitySqlDaoWrapperFactory.getHandle().getConnection());
        }
        catch (PersistentBus.EventBusException e) {
            log.warn("Failed to post tag event for tagId='{}'", (Object)tag.getId().toString(), (Object)e);
        }
    }

    @Override
    protected boolean checkEntityAlreadyExists(EntitySqlDao<TagModelDao, Tag> transactional, final TagModelDao entity, InternalCallContext context) {
        return Iterables.find(transactional.getByAccountRecordId((InternalTenantContext)context), (Predicate)new Predicate<TagModelDao>(){

            public boolean apply(TagModelDao existingTag) {
                return entity.equals(existingTag) || entity.isSame(existingTag);
            }
        }, null) != null;
    }

    @Override
    protected TagApiException generateAlreadyExistsException(TagModelDao entity, InternalCallContext context) {
        return new TagApiException(ErrorCode.TAG_ALREADY_EXISTS, new Object[]{entity.toString()});
    }

    private TagDefinitionModelDao getTagDefinitionFromTransaction(UUID tagDefinitionId, EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory, InternalTenantContext context) throws TagApiException {
        TagDefinitionModelDao tagDefintion = SystemTags.lookup(tagDefinitionId);
        if (tagDefintion == null) {
            TagDefinitionSqlDao transTagDefintionSqlDao = entitySqlDaoWrapperFactory.become(TagDefinitionSqlDao.class);
            tagDefintion = (TagDefinitionModelDao)transTagDefintionSqlDao.getById(tagDefinitionId.toString(), context);
        }
        if (tagDefintion == null) {
            throw new TagApiException(ErrorCode.TAG_DEFINITION_DOES_NOT_EXIST, new Object[]{tagDefinitionId});
        }
        return tagDefintion;
    }

    @Override
    public void create(TagModelDao entity, InternalCallContext context) throws TagApiException {
        this.validateApplicableObjectTypes(entity.getTagDefinitionId(), entity.getObjectType());
        this.transactionalSqlDao.execute(false, TagApiException.class, this.getCreateEntitySqlDaoTransactionWrapper(entity, context));
    }

    private void validateApplicableObjectTypes(final UUID tagDefinitionId, ObjectType objectType) throws TagApiException {
        ControlTagType controlTagType = (ControlTagType)Iterables.tryFind((Iterable)ImmutableList.copyOf((Object[])ControlTagType.values()), (Predicate)new Predicate<ControlTagType>(){

            public boolean apply(ControlTagType input) {
                return input.getId().equals(tagDefinitionId);
            }
        }).orNull();
        if (controlTagType != null && !controlTagType.getApplicableObjectTypes().contains(objectType)) {
            throw new IllegalStateException(String.format("Invalid control tag '%s' for object type '%s'", controlTagType.name(), objectType));
        }
    }

    @Override
    public void deleteTag(final UUID objectId, final ObjectType objectType, final UUID tagDefinitionId, final InternalCallContext context) throws TagApiException {
        this.transactionalSqlDao.execute(false, TagApiException.class, new EntitySqlDaoTransactionWrapper<Void>(){

            @Override
            public Void inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                TagDefinitionModelDao tagDefinition = DefaultTagDao.this.getTagDefinitionFromTransaction(tagDefinitionId, entitySqlDaoWrapperFactory, (InternalTenantContext)context);
                TagSqlDao transactional = entitySqlDaoWrapperFactory.become(TagSqlDao.class);
                List<TagModelDao> tags = transactional.getTagsForObject(objectId, objectType, (InternalTenantContext)context);
                TagModelDao tag = null;
                for (TagModelDao cur : tags) {
                    if (!cur.getTagDefinitionId().equals(tagDefinitionId)) continue;
                    tag = cur;
                    break;
                }
                if (tag == null) {
                    throw new TagApiException(ErrorCode.TAG_DOES_NOT_EXIST, new Object[]{tagDefinition.getName()});
                }
                transactional.markTagAsDeleted(tag.getId().toString(), context);
                DefaultTagDao.this.postBusEventFromTransaction(tag, tag, ChangeType.DELETE, entitySqlDaoWrapperFactory, context);
                return null;
            }
        });
    }

    @Override
    public Pagination<TagModelDao> searchTags(final String searchKey, Long offset, Long limit, InternalTenantContext context) {
        return this.paginationHelper.getPagination(TagSqlDao.class, new DefaultPaginationSqlDaoHelper.PaginationIteratorBuilder<TagModelDao, Tag, TagSqlDao>(){

            @Override
            public Long getCount(TagSqlDao tagSqlDao, InternalTenantContext context) {
                return tagSqlDao.getSearchCount(searchKey, String.format("%%%s%%", searchKey), context);
            }

            @Override
            public Iterator<TagModelDao> build(TagSqlDao tagSqlDao, Long offset, Long limit, DefaultPaginationSqlDaoHelper.Ordering ordering, InternalTenantContext context) {
                return tagSqlDao.search(searchKey, String.format("%%%s%%", searchKey), offset, limit, ordering.toString(), context);
            }
        }, offset, limit, context);
    }
}

