/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.tag.dao;

import com.google.common.base.Joiner;
import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.dao.TableName;
import org.killbill.billing.util.entity.dao.EntityModelDao;
import org.killbill.billing.util.entity.dao.EntityModelDaoBase;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.billing.util.tag.TagDefinition;

public class TagDefinitionModelDao
extends EntityModelDaoBase
implements EntityModelDao<TagDefinition> {
    private static final Joiner JOINER = Joiner.on((String)",");
    private String name;
    private String applicableObjectTypes;
    private String description;
    private Boolean isActive;

    public TagDefinitionModelDao() {
    }

    public TagDefinitionModelDao(UUID id, DateTime createdDate, DateTime updatedDate, String name, String description, String applicableObjectTypes) {
        super(id, createdDate, updatedDate);
        this.name = name;
        this.description = description;
        this.isActive = true;
        this.applicableObjectTypes = applicableObjectTypes;
    }

    public TagDefinitionModelDao(ControlTagType tag) {
        this(tag.getId(), null, null, tag.name(), tag.getDescription(), JOINER.join((Iterable)tag.getApplicableObjectTypes()));
    }

    public TagDefinitionModelDao(DateTime createdDate, String name, String description, String applicableObjectTypes) {
        this(UUIDs.randomUUID(), createdDate, createdDate, name, description, applicableObjectTypes);
    }

    public TagDefinitionModelDao(TagDefinition tagDefinition) {
        this(tagDefinition.getId(), tagDefinition.getCreatedDate(), tagDefinition.getUpdatedDate(), tagDefinition.getName(), tagDefinition.getDescription(), JOINER.join((Iterable)tagDefinition.getApplicableObjectTypes()));
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public String getApplicableObjectTypes() {
        return this.applicableObjectTypes;
    }

    public void setApplicableObjectTypes(String applicableObjectTypes) {
        this.applicableObjectTypes = applicableObjectTypes;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TagDefinitionModelDao");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", applicableObjectTypes='").append(this.applicableObjectTypes).append('\'');
        sb.append(", isActive=").append(this.isActive);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TagDefinitionModelDao that = (TagDefinitionModelDao)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.isActive != null ? !this.isActive.equals(that.isActive) : that.isActive != null) {
            return false;
        }
        if (this.applicableObjectTypes != null ? !this.applicableObjectTypes.equals(that.applicableObjectTypes) : that.applicableObjectTypes != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.isActive != null ? this.isActive.hashCode() : 0);
        result = 31 * result + (this.applicableObjectTypes != null ? this.applicableObjectTypes.hashCode() : 0);
        return result;
    }

    @Override
    public TableName getTableName() {
        return TableName.TAG_DEFINITIONS;
    }

    @Override
    public TableName getHistoryTableName() {
        return TableName.TAG_DEFINITION_HISTORY;
    }
}

