/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.tag.dao;

import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.ObjectType;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.dao.TableName;
import org.killbill.billing.util.entity.dao.EntityModelDao;
import org.killbill.billing.util.entity.dao.EntityModelDaoBase;
import org.killbill.billing.util.tag.Tag;

public class TagModelDao
extends EntityModelDaoBase
implements EntityModelDao<Tag> {
    private UUID tagDefinitionId;
    private UUID objectId;
    private ObjectType objectType;
    private Boolean isActive;

    public TagModelDao() {
    }

    public TagModelDao(DateTime createdDate, UUID tagDefinitionId, UUID objectId, ObjectType objectType) {
        this(UUIDs.randomUUID(), createdDate, createdDate, tagDefinitionId, objectId, objectType);
    }

    public TagModelDao(UUID id, DateTime createdDate, DateTime updatedDate, UUID tagDefinitionId, UUID objectId, ObjectType objectType) {
        super(id, createdDate, updatedDate);
        this.tagDefinitionId = tagDefinitionId;
        this.objectId = objectId;
        this.objectType = objectType;
        this.isActive = true;
    }

    public TagModelDao(Tag tag) {
        this(tag.getId(), tag.getCreatedDate(), tag.getUpdatedDate(), tag.getTagDefinitionId(), tag.getObjectId(), tag.getObjectType());
    }

    public UUID getTagDefinitionId() {
        return this.tagDefinitionId;
    }

    public UUID getObjectId() {
        return this.objectId;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setTagDefinitionId(UUID tagDefinitionId) {
        this.tagDefinitionId = tagDefinitionId;
    }

    public void setObjectId(UUID objectId) {
        this.objectId = objectId;
    }

    public void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TagModelDao");
        sb.append("{tagDefinitionId=").append(this.tagDefinitionId);
        sb.append(", objectId=").append(this.objectId);
        sb.append(", objectType=").append(this.objectType);
        sb.append(", isActive=").append(this.isActive);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TagModelDao that = (TagModelDao)o;
        return this.isSame(that);
    }

    public boolean isSame(TagModelDao that) {
        if (this.isActive != null ? !this.isActive.equals(that.isActive) : that.isActive != null) {
            return false;
        }
        if (this.objectId != null ? !this.objectId.equals(that.objectId) : that.objectId != null) {
            return false;
        }
        if (this.objectType != that.objectType) {
            return false;
        }
        return !(this.tagDefinitionId != null ? !this.tagDefinitionId.equals(that.tagDefinitionId) : that.tagDefinitionId != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.tagDefinitionId != null ? this.tagDefinitionId.hashCode() : 0);
        result = 31 * result + (this.objectId != null ? this.objectId.hashCode() : 0);
        result = 31 * result + (this.objectType != null ? this.objectType.hashCode() : 0);
        result = 31 * result + (this.isActive != null ? this.isActive.hashCode() : 0);
        return result;
    }

    @Override
    public TableName getTableName() {
        return TableName.TAG;
    }

    @Override
    public TableName getHistoryTableName() {
        return TableName.TAG_HISTORY;
    }
}

