/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.userrequest;

import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.killbill.billing.events.AccountChangeInternalEvent;
import org.killbill.billing.events.AccountCreationInternalEvent;
import org.killbill.billing.events.BlockingTransitionInternalEvent;
import org.killbill.billing.events.BusInternalEvent;
import org.killbill.billing.events.EffectiveSubscriptionInternalEvent;
import org.killbill.billing.events.InvoiceCreationInternalEvent;
import org.killbill.billing.events.InvoicePaymentErrorInternalEvent;
import org.killbill.billing.events.InvoicePaymentInfoInternalEvent;
import org.killbill.billing.events.NullInvoiceInternalEvent;
import org.killbill.billing.events.PaymentErrorInternalEvent;
import org.killbill.billing.events.PaymentInfoInternalEvent;
import org.killbill.billing.events.PaymentPluginErrorInternalEvent;
import org.killbill.billing.util.userrequest.CompletionUserRequest;

public class CompletionUserRequestBase
implements CompletionUserRequest {
    private static final long NANO_TO_MILLI_SEC = 1000000L;
    private final List<BusInternalEvent> events = new LinkedList<BusInternalEvent>();
    private final UUID userToken;
    private long timeoutMilliSec;
    private boolean isCompleted;
    private long initialTimeMilliSec;

    public CompletionUserRequestBase(UUID userToken) {
        this.userToken = userToken;
        this.isCompleted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BusInternalEvent> waitForCompletion(long timeoutMilliSec) throws InterruptedException, TimeoutException {
        this.timeoutMilliSec = timeoutMilliSec;
        this.initialTimeMilliSec = this.currentTimeMillis();
        CompletionUserRequestBase completionUserRequestBase = this;
        synchronized (completionUserRequestBase) {
            long remainingTimeMillisSec = this.getRemainingTimeMillis();
            while (!this.isCompleted && remainingTimeMillisSec > 0L) {
                this.wait(remainingTimeMillisSec);
                if (this.isCompleted) break;
                remainingTimeMillisSec = this.getRemainingTimeMillis();
            }
            if (!this.isCompleted) {
                throw new TimeoutException();
            }
        }
        return this.events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyForCompletion() {
        CompletionUserRequestBase completionUserRequestBase = this;
        synchronized (completionUserRequestBase) {
            this.isCompleted = true;
            this.notify();
        }
    }

    private long currentTimeMillis() {
        return System.nanoTime() / 1000000L;
    }

    private long getRemainingTimeMillis() {
        return this.timeoutMilliSec - (this.currentTimeMillis() - this.initialTimeMilliSec);
    }

    @Override
    public void onBusEvent(BusInternalEvent curEvent) {
        if (curEvent.getUserToken() == null || !curEvent.getUserToken().equals(this.userToken)) {
            return;
        }
        this.events.add(curEvent);
        switch (curEvent.getBusEventType()) {
            case ACCOUNT_CREATE: {
                this.onAccountCreation((AccountCreationInternalEvent)curEvent);
                break;
            }
            case ACCOUNT_CHANGE: {
                this.onAccountChange((AccountChangeInternalEvent)curEvent);
                break;
            }
            case BLOCKING_STATE: {
                this.onBlockingState((BlockingTransitionInternalEvent)curEvent);
                break;
            }
            case SUBSCRIPTION_TRANSITION: {
                if (!(curEvent instanceof EffectiveSubscriptionInternalEvent)) break;
                this.onSubscriptionBaseTransition((EffectiveSubscriptionInternalEvent)curEvent);
                break;
            }
            case INVOICE_EMPTY: {
                this.onEmptyInvoice((NullInvoiceInternalEvent)curEvent);
                break;
            }
            case INVOICE_CREATION: {
                this.onInvoiceCreation((InvoiceCreationInternalEvent)curEvent);
                break;
            }
            case PAYMENT_INFO: {
                this.onPaymentInfo((PaymentInfoInternalEvent)curEvent);
                break;
            }
            case PAYMENT_ERROR: {
                this.onPaymentError((PaymentErrorInternalEvent)curEvent);
                break;
            }
            case PAYMENT_PLUGIN_ERROR: {
                this.onPaymentPluginError((PaymentPluginErrorInternalEvent)curEvent);
                break;
            }
            case INVOICE_PAYMENT_INFO: {
                this.onInvoicePaymentInfo((InvoicePaymentInfoInternalEvent)curEvent);
                break;
            }
            case INVOICE_PAYMENT_ERROR: {
                this.onInvoicePaymentError((InvoicePaymentErrorInternalEvent)curEvent);
                break;
            }
        }
    }

    @Override
    public void onAccountCreation(AccountCreationInternalEvent curEvent) {
    }

    @Override
    public void onAccountChange(AccountChangeInternalEvent curEvent) {
    }

    @Override
    public void onSubscriptionBaseTransition(EffectiveSubscriptionInternalEvent curEventEffective) {
    }

    @Override
    public void onBlockingState(BlockingTransitionInternalEvent curEvent) {
    }

    @Override
    public void onInvoiceCreation(InvoiceCreationInternalEvent curEvent) {
    }

    @Override
    public void onEmptyInvoice(NullInvoiceInternalEvent curEvent) {
    }

    @Override
    public void onPaymentInfo(PaymentInfoInternalEvent curEvent) {
    }

    @Override
    public void onPaymentError(PaymentErrorInternalEvent curEvent) {
    }

    @Override
    public void onPaymentPluginError(PaymentPluginErrorInternalEvent curEvent) {
    }

    @Override
    public void onInvoicePaymentInfo(InvoicePaymentInfoInternalEvent curEvent) {
    }

    @Override
    public void onInvoicePaymentError(InvoicePaymentErrorInternalEvent curEvent) {
    }
}

