/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.validation;

import com.google.inject.Inject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.killbill.billing.util.validation.DefaultColumnInfo;
import org.killbill.billing.util.validation.ValidationConfiguration;
import org.killbill.billing.util.validation.dao.DatabaseSchemaDao;

public class ValidationManager {
    private final DatabaseSchemaDao dao;
    private final Map<String, Map<String, DefaultColumnInfo>> columnInfoMap = new HashMap<String, Map<String, DefaultColumnInfo>>();
    private final Map<Class, ValidationConfiguration> configurations = new HashMap<Class, ValidationConfiguration>();

    @Inject
    public ValidationManager(DatabaseSchemaDao dao) {
        this.dao = dao;
    }

    public void loadSchemaInformation(String schemaName) {
        this.columnInfoMap.clear();
        List<DefaultColumnInfo> columnInfoList = this.dao.getColumnInfoList(schemaName);
        for (DefaultColumnInfo columnInfo : columnInfoList) {
            String tableName = columnInfo.getTableName();
            if (!this.columnInfoMap.containsKey(tableName)) {
                this.columnInfoMap.put(tableName, new HashMap());
            }
            this.columnInfoMap.get(tableName).put(columnInfo.getColumnName(), columnInfo);
        }
    }

    public Collection<DefaultColumnInfo> getTableInfo(String tableName) {
        return this.columnInfoMap.get(tableName).values();
    }

    public DefaultColumnInfo getColumnInfo(String tableName, String columnName) {
        return this.columnInfoMap.get(tableName) == null ? null : this.columnInfoMap.get(tableName).get(columnName);
    }

    public boolean validate(Object o) {
        ValidationConfiguration configuration = this.getConfiguration(o.getClass());
        if (configuration == null) {
            return true;
        }
        Class<?> clazz = o.getClass();
        for (String propertyName : configuration.keySet()) {
            try {
                Field field = clazz.getDeclaredField(propertyName);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                Object value = field.get(o);
                DefaultColumnInfo columnInfo = (DefaultColumnInfo)configuration.get(propertyName);
                if (columnInfo == null) {
                    return true;
                }
                if (!this.hasValidNullability(columnInfo, value)) {
                    return false;
                }
                if (!this.isValidLengthString(columnInfo, value)) {
                    return false;
                }
                if (!this.isValidLengthChar(columnInfo, value)) {
                    return false;
                }
                if (!this.hasValidPrecision(columnInfo, value)) {
                    return false;
                }
                if (this.hasValidScale(columnInfo, value)) continue;
                return false;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
        }
        return true;
    }

    private boolean hasValidNullability(DefaultColumnInfo columnInfo, Object value) {
        return columnInfo.getIsNullable() || value != null;
    }

    private boolean isValidLengthString(DefaultColumnInfo columnInfo, Object value) {
        return columnInfo.getMaximumLength() == 0L || value == null || !(value instanceof String) || (long)value.toString().length() <= columnInfo.getMaximumLength();
    }

    private boolean isValidLengthChar(DefaultColumnInfo columnInfo, Object value) {
        if ("char".equals(columnInfo.getDataType()) || "character".equals(columnInfo.getDataType()) || String.valueOf(1).equals(columnInfo.getDataType())) {
            if (value == null) {
                return false;
            }
            if ((long)value.toString().length() != columnInfo.getMaximumLength()) {
                return false;
            }
        }
        return true;
    }

    private boolean hasValidPrecision(DefaultColumnInfo columnInfo, Object value) {
        BigDecimal bigDecimalValue;
        return columnInfo.getPrecision() == 0L || value == null || value instanceof String || (long)(bigDecimalValue = new BigDecimal(value.toString())).precision() <= columnInfo.getPrecision();
    }

    private boolean hasValidScale(DefaultColumnInfo columnInfo, Object value) {
        BigDecimal bigDecimalValue;
        return columnInfo.getScale() == 0L || value == null || (long)(bigDecimalValue = new BigDecimal(value.toString())).scale() <= columnInfo.getScale();
    }

    public boolean hasConfiguration(Class clazz) {
        return this.configurations.containsKey(clazz);
    }

    public ValidationConfiguration getConfiguration(Class clazz) {
        return this.configurations.get(clazz);
    }

    public void setConfiguration(Class clazz, String propertyName, DefaultColumnInfo columnInfo) {
        if (!this.configurations.containsKey(clazz)) {
            this.configurations.put(clazz, new ValidationConfiguration());
        }
        this.configurations.get(clazz).addMapping(propertyName, columnInfo);
    }
}

