/*
 * Copyright 2014-2017 Groupon, Inc
 * Copyright 2014-2017 The Billing Project, LLC
 *
 * The Billing Project licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package org.killbill.billing.invoice.plugin.api;

import java.util.List;

import org.joda.time.Period;
import org.killbill.billing.util.queue.QueueRetryException;

public class InvoicePluginApiRetryException extends QueueRetryException {

    public InvoicePluginApiRetryException() {
    }

    public InvoicePluginApiRetryException(final Exception e) {
        super(e);
    }

    public InvoicePluginApiRetryException(final List<Period> retrySchedule) {
        super(retrySchedule);
    }

    public InvoicePluginApiRetryException(final Exception e, final List<Period> retrySchedule) {
        super(e, retrySchedule);
    }
}
