/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.clock;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.killbill.clock.ClockUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestClockUtil {
    @Test(groups={"fast"})
    public void testWithInputInThePast() {
        DateTimeZone inputTimeZone = DateTimeZone.forOffsetHours((int)1);
        LocalDate inputDateInTargetTimeZone = new LocalDate(2014, 10, 23);
        LocalTime inputTimeInUTC = new LocalTime(10, 23, 5);
        DateTime result = ClockUtil.toUTCDateTime((LocalDate)inputDateInTargetTimeZone, (LocalTime)inputTimeInUTC, (DateTimeZone)inputTimeZone);
        Assert.assertEquals((int)result.compareTo((ReadableInstant)new DateTime(2014, 10, 23, 9, 23, 5, DateTimeZone.UTC)), (int)0);
        Assert.assertEquals((int)result.toDateTime(inputTimeZone).toLocalDate().compareTo((ReadablePartial)inputDateInTargetTimeZone), (int)0);
    }

    @Test(groups={"fast"})
    public void testWithInputInTheFuture() {
        DateTimeZone inputTimeZone = DateTimeZone.forOffsetHours((int)-1);
        LocalDate inputDateInTargetTimeZone = new LocalDate(2014, 10, 23);
        LocalTime inputTimeInUTC = new LocalTime(10, 23, 5);
        DateTime result = ClockUtil.toUTCDateTime((LocalDate)inputDateInTargetTimeZone, (LocalTime)inputTimeInUTC, (DateTimeZone)inputTimeZone);
        Assert.assertEquals((int)result.compareTo((ReadableInstant)new DateTime(2014, 10, 23, 11, 23, 5, DateTimeZone.UTC)), (int)0);
        Assert.assertEquals((int)result.toDateTime(inputTimeZone).toLocalDate().compareTo((ReadablePartial)inputDateInTargetTimeZone), (int)0);
    }
}

