/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.clock;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.killbill.clock.ClockMock;
import org.testng.Assert;

public abstract class TestClockMockBase {
    protected void testBasicClockOperations(final ClockMock clock) throws Exception {
        final DateTime startingTime = new DateTime(DateTimeZone.UTC);
        Awaitility.await().atMost(1500L, TimeUnit.MILLISECONDS).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return clock.getUTCNow().isAfter((ReadableInstant)startingTime);
            }
        });
        clock.setTime(new DateTime(2012, 5, 1, 1, 2, 3, DateTimeZone.UTC));
        Assert.assertEquals((Object)clock.getUTCToday(), (Object)new LocalDate(2012, 5, 1));
        DateTime utcNowAfterSetTime = clock.getUTCNow();
        Assert.assertEquals((int)utcNowAfterSetTime.getHourOfDay(), (int)1);
        Assert.assertEquals((int)utcNowAfterSetTime.getMinuteOfHour(), (int)2);
        Assert.assertEquals((int)utcNowAfterSetTime.getSecondOfMinute(), (int)3);
        clock.addDays(1);
        Assert.assertEquals((Object)clock.getUTCToday(), (Object)new LocalDate(2012, 5, 2));
        clock.addMonths(1);
        Assert.assertEquals((Object)clock.getUTCToday(), (Object)new LocalDate(2012, 6, 2));
        clock.addYears(1);
        Assert.assertEquals((Object)clock.getUTCToday(), (Object)new LocalDate(2013, 6, 2));
        clock.setDay(new LocalDate(2045, 12, 12));
        Assert.assertEquals((Object)clock.getUTCToday(), (Object)new LocalDate(2045, 12, 12));
        clock.resetDeltaFromReality();
        Assert.assertTrue((boolean)clock.getUTCNow().isAfter((ReadableInstant)startingTime));
        Assert.assertTrue((boolean)clock.getUTCNow().isBefore((ReadableInstant)startingTime.plusMinutes(1)));
    }
}

