/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.clock;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.Months;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.Weeks;
import org.joda.time.Years;
import org.killbill.clock.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClockMock
implements Clock {
    private static final Logger log = LoggerFactory.getLogger(ClockMock.class);
    private DateTime mockDateTime;
    private long initialDeltaMillis;

    public ClockMock() {
        this.reset();
    }

    public synchronized DateTime getNow(DateTimeZone tz) {
        return this.getUTCNow().toDateTime(tz);
    }

    public synchronized DateTime getUTCNow() {
        return this.truncate(this.mockDateTime.plus(System.currentTimeMillis() - this.initialDeltaMillis));
    }

    public LocalDate getUTCToday() {
        return this.getToday(DateTimeZone.UTC);
    }

    public LocalDate getToday(DateTimeZone timeZone) {
        return new LocalDate((Object)this.getUTCNow(), timeZone);
    }

    public String toString() {
        return this.getUTCNow().toString();
    }

    public synchronized void addDays(int days) {
        this.adjustTo((ReadablePeriod)Days.days((int)days));
    }

    public synchronized void addWeeks(int weeks) {
        this.adjustTo((ReadablePeriod)Weeks.weeks((int)weeks));
    }

    public synchronized void addMonths(int months) {
        this.adjustTo((ReadablePeriod)Months.months((int)months));
    }

    public synchronized void addYears(int years) {
        this.adjustTo((ReadablePeriod)Years.years((int)years));
    }

    public synchronized void setDeltaFromReality(long delta) {
        this.addDeltaFromReality(delta);
    }

    public synchronized void addDeltaFromReality(long delta) {
        this.adjustTo((ReadablePeriod)new Period(delta));
    }

    public synchronized void setDay(LocalDate date) {
        this.setTime(date.toDateTimeAtStartOfDay(DateTimeZone.UTC));
    }

    public synchronized void setTime(DateTime time) {
        DateTime prev = this.getUTCNow();
        this.reset(time);
        this.logChange(prev);
    }

    public synchronized void resetDeltaFromReality() {
        this.reset();
    }

    private synchronized void reset() {
        this.reset(this.realNow());
    }

    private void reset(DateTime time) {
        this.mockDateTime = time;
        this.initialDeltaMillis = System.currentTimeMillis();
    }

    private void adjustTo(ReadablePeriod period) {
        DateTime prev = this.getUTCNow();
        this.mockDateTime = this.mockDateTime.plus(period);
        this.logChange(prev);
    }

    private void logChange(DateTime prev) {
        DateTime now = this.getUTCNow();
        log.info(String.format("            ************      ADJUSTING CLOCK FROM %s to %s     ********************", prev, now));
    }

    private DateTime truncate(DateTime time) {
        return time.minus((long)time.getMillisOfSecond());
    }

    private DateTime realNow() {
        return new DateTime(DateTimeZone.UTC);
    }
}

