/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.clock;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.killbill.clock.Clock;
import org.killbill.clock.ClockMock;
import org.killbill.clock.ClockUtil;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestClockUtil {
    private ClockMock clock;

    @BeforeMethod(groups={"fast"})
    public void beforeMethod() {
        this.clock = new ClockMock();
    }

    @Test(groups={"fast"})
    public void testWithInputInThePast() {
        DateTimeZone inputTimeZone = DateTimeZone.forOffsetHours((int)1);
        LocalDate inputDateInTargetTimeZone = new LocalDate(2014, 10, 23);
        LocalTime inputTimeInUTC = new LocalTime(10, 23, 5);
        DateTime utcNow = new DateTime(2014, 10, 23, 23, 44, 1, DateTimeZone.UTC);
        this.clock.setTime(utcNow);
        DateTime result = ClockUtil.computeDateTimeWithUTCReferenceTime((LocalDate)inputDateInTargetTimeZone, (LocalTime)inputTimeInUTC, (DateTimeZone)inputTimeZone, (Clock)this.clock);
        Assert.assertEquals((int)result.compareTo((ReadableInstant)new DateTime(2014, 10, 23, 10, 23, 5, DateTimeZone.UTC)), (int)0);
        Assert.assertEquals((int)result.toDateTime(inputTimeZone).toLocalDate().compareTo((ReadablePartial)inputDateInTargetTimeZone), (int)0);
    }

    @Test(groups={"fast"})
    public void testWithInputInThePresent() {
        DateTimeZone inputTimeZone = DateTimeZone.forOffsetHours((int)1);
        LocalDate inputDateInTargetTimeZone = new LocalDate(2014, 10, 23);
        LocalTime inputTimeInUTC = new LocalTime(10, 23, 5);
        DateTime utcNow = new DateTime(2014, 10, 23, 22, 44, 1, DateTimeZone.UTC);
        this.clock.setTime(utcNow);
        DateTime result = ClockUtil.computeDateTimeWithUTCReferenceTime((LocalDate)inputDateInTargetTimeZone, (LocalTime)inputTimeInUTC, (DateTimeZone)inputTimeZone, (Clock)this.clock);
        Assert.assertEquals((int)result.compareTo((ReadableInstant)utcNow), (int)0);
        Assert.assertEquals((int)result.toDateTime(inputTimeZone).toLocalDate().compareTo((ReadablePartial)inputDateInTargetTimeZone), (int)0);
    }

    @Test(groups={"fast"})
    public void testWithInputInTheFuture() {
        DateTimeZone inputTimeZone = DateTimeZone.forOffsetHours((int)-1);
        LocalDate inputDateInTargetTimeZone = new LocalDate(2014, 10, 23);
        LocalTime inputTimeInUTC = new LocalTime(10, 23, 5);
        DateTime utcNow = new DateTime(2014, 10, 23, 0, 44, 1, DateTimeZone.UTC);
        this.clock.setTime(utcNow);
        DateTime result = ClockUtil.computeDateTimeWithUTCReferenceTime((LocalDate)inputDateInTargetTimeZone, (LocalTime)inputTimeInUTC, (DateTimeZone)inputTimeZone, (Clock)this.clock);
        Assert.assertEquals((int)result.compareTo((ReadableInstant)new DateTime(2014, 10, 23, 10, 23, 5, DateTimeZone.UTC)), (int)0);
        Assert.assertEquals((int)result.toDateTime(inputTimeZone).toLocalDate().compareTo((ReadablePartial)inputDateInTargetTimeZone), (int)0);
    }
}

