/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.concurrent;

import org.slf4j.Logger;

class WrappedRunnable
implements Runnable {
    private final Logger log;
    private final Runnable runnable;
    private volatile Throwable exception;

    private WrappedRunnable(Logger log, Runnable runnable) {
        this.log = log;
        this.runnable = runnable;
    }

    public static WrappedRunnable wrap(Logger log, Runnable runnable) {
        return runnable instanceof WrappedRunnable ? (WrappedRunnable)runnable : new WrappedRunnable(log, runnable);
    }

    Throwable getException() {
        return this.exception;
    }

    public void run() {
        Thread currentThread = Thread.currentThread();
        try {
            this.runnable.run();
        }
        catch (Throwable e) {
            this.log.error(currentThread + " ended abnormally with an exception", e);
            this.exception = e;
        }
        this.log.debug("{} finished executing", (Object)currentThread);
    }
}

