/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.profiling;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProfilingFeature {
    private static final int JAXRS_MASK = 1;
    private static final int API_MASK = 2;
    private static final int DAO_MASK = 4;
    private static final int DAO_DETAILS_MASK = 8;
    private static final int GLOCK_MASK = 16;
    private static final int PLUGIN_MASK = 32;
    private static final int DAO_CONNECTION_MASK = 64;
    private final Pattern featurePattern = Pattern.compile("\\s*,?\\s*((?:[A-Z])+(?:_)?+(?:[A-Z])*)");
    private final int profilingBits;

    public ProfilingFeature() {
        int tmp = 0;
        for (ProfilingFeatureType cur : ProfilingFeatureType.values()) {
            tmp |= cur.getMask();
        }
        this.profilingBits = tmp;
    }

    public ProfilingFeature(String features) {
        int tmp = 0;
        Matcher matcher = this.featurePattern.matcher(features);
        while (matcher.find()) {
            String cur = matcher.group(1);
            try {
                ProfilingFeatureType featureType = ProfilingFeatureType.valueOf(cur);
                tmp |= featureType.getMask();
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.profilingBits = tmp;
    }

    public boolean isDefined(ProfilingFeatureType type) {
        return (this.profilingBits & type.getMask()) == type.getMask();
    }

    public boolean isProfilingJAXRS() {
        return this.isDefined(ProfilingFeatureType.JAXRS);
    }

    public boolean isProfilingAPI() {
        return this.isDefined(ProfilingFeatureType.API);
    }

    public boolean isProfilingDAO() {
        return this.isDefined(ProfilingFeatureType.DAO);
    }

    public boolean isProfilingDAOWithDetails() {
        return this.isDefined(ProfilingFeatureType.DAO_DETAILS);
    }

    public boolean isProfilingPlugin() {
        return this.isDefined(ProfilingFeatureType.PLUGIN);
    }

    public boolean isProfilingGlock() {
        return this.isDefined(ProfilingFeatureType.GLOCK);
    }

    public boolean isProfilingDaoConnection() {
        return this.isDefined(ProfilingFeatureType.DAO_CONNECTION);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProfilingFeatureType {
        JAXRS(1),
        API(2),
        DAO(4),
        DAO_DETAILS(4, 8),
        DAO_CONNECTION(64),
        GLOCK(16),
        PLUGIN(32);

        private final int mask;

        private ProfilingFeatureType(int ... masks) {
            int tmp = 0;
            for (int mask1 : masks) {
                tmp |= mask1;
            }
            this.mask = tmp;
        }

        public int getMask() {
            return this.mask;
        }
    }
}

