/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.killbill.commons.concurrent.NamedThreadFactory;
import org.killbill.commons.concurrent.WrappedCallable;
import org.killbill.commons.concurrent.WrappedRunnable;
import org.killbill.commons.concurrent.WrappedRunnableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailsafeScheduledExecutor
extends ScheduledThreadPoolExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(FailsafeScheduledExecutor.class);

    public FailsafeScheduledExecutor(String name) {
        this(1, name);
    }

    public FailsafeScheduledExecutor(int corePoolSize, String name) {
        this(corePoolSize, new NamedThreadFactory(name));
    }

    public FailsafeScheduledExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    public FailsafeScheduledExecutor(int corePoolSize, String name, RejectedExecutionHandler handler) {
        super(corePoolSize, new NamedThreadFactory(name), handler);
    }

    public FailsafeScheduledExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return super.submit(WrappedCallable.wrap(LOG, task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        WrappedRunnable runnable = WrappedRunnable.wrap(LOG, task);
        Future<T> future = super.submit(runnable, result);
        return WrappedRunnableFuture.wrap(runnable, future);
    }

    @Override
    public Future<?> submit(Runnable task) {
        WrappedRunnable runnable = WrappedRunnable.wrap(LOG, task);
        Future<?> future = super.submit(runnable);
        return WrappedRunnableFuture.wrap(runnable, future);
    }

    @Override
    public void execute(Runnable command) {
        super.execute(WrappedRunnable.wrap(LOG, command));
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return super.scheduleWithFixedDelay(WrappedRunnable.wrap(LOG, command), initialDelay, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return super.scheduleAtFixedRate(WrappedRunnable.wrap(LOG, command), initialDelay, period, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return super.schedule(WrappedCallable.wrap(LOG, callable), delay, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return super.schedule(WrappedRunnable.wrap(LOG, command), delay, unit);
    }
}

