/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.profiling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.killbill.commons.profiling.ProfilingFeature;

public class ProfilingData {
    private final List<ProfilingDataItem> rawData;
    private final ProfilingFeature profileFeature;

    public ProfilingData(ProfilingFeature profileFeature) {
        this.profileFeature = profileFeature;
        this.rawData = new ArrayList<ProfilingDataItem>();
    }

    public void merge(@Nullable ProfilingData otherData) {
        if (otherData == null || otherData.getRawData().isEmpty()) {
            return;
        }
        this.rawData.addAll(otherData.getRawData());
        Collections.sort(this.rawData, new Comparator<ProfilingDataItem>(){

            @Override
            public int compare(ProfilingDataItem o1, ProfilingDataItem o2) {
                return o1.getTimestampNsec().compareTo(o2.getTimestampNsec());
            }
        });
    }

    public void addStart(ProfilingFeature.ProfilingFeatureType profileType, String id) {
        this.rawData.add(new ProfilingDataItem(profileType, id, LogLineType.START));
    }

    public void addEnd(ProfilingFeature.ProfilingFeatureType profileType, String id) {
        this.rawData.add(new ProfilingDataItem(profileType, id, LogLineType.END));
    }

    public List<ProfilingDataItem> getRawData() {
        if (this.rawData == null || this.rawData.isEmpty()) {
            return Collections.emptyList();
        }
        return this.rawData.stream().filter(input -> input != null && this.profileFeature.isDefined(input.getProfileType())).collect(Collectors.toList());
    }

    public ProfilingFeature getProfileFeature() {
        return this.profileFeature;
    }

    public static enum LogLineType {
        START,
        END;

    }

    public static class ProfilingDataItem {
        private final ProfilingFeature.ProfilingFeatureType profileType;
        private final String id;
        private final Long timestampNsec;
        private final LogLineType lineType;

        private ProfilingDataItem(ProfilingFeature.ProfilingFeatureType profileType, String id, LogLineType lineType) {
            this.profileType = profileType;
            this.id = id;
            this.lineType = lineType;
            this.timestampNsec = System.nanoTime();
        }

        public ProfilingFeature.ProfilingFeatureType getProfileType() {
            return this.profileType;
        }

        public String getKey() {
            return this.profileType + ":" + this.id;
        }

        public Long getTimestampNsec() {
            return this.timestampNsec;
        }

        public LogLineType getLineType() {
            return this.lineType;
        }
    }
}

