/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.concurrent;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.killbill.commons.concurrent.FailsafeScheduledExecutor;
import org.killbill.commons.concurrent.LoggingExecutor;
import org.killbill.commons.concurrent.NamedThreadFactory;

public class Executors {
    public static ExecutorService newFixedThreadPool(int nThreads, String name) {
        return new LoggingExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(name));
    }

    public static ExecutorService newFixedThreadPool(int nThreads, String name, long keepAliveTime, TimeUnit unit) {
        return new LoggingExecutor(nThreads, nThreads, keepAliveTime, unit, new NamedThreadFactory(name));
    }

    public static ExecutorService newFixedThreadPool(int nThreads, String name, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        return new LoggingExecutor(nThreads, nThreads, keepAliveTime, unit, workQueue, new NamedThreadFactory(name));
    }

    public static ExecutorService newFixedThreadPool(int nThreads, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        return new LoggingExecutor(nThreads, nThreads, keepAliveTime, unit, workQueue, threadFactory);
    }

    public static ExecutorService newFixedThreadPool(int nThreads, String name, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        return new LoggingExecutor(nThreads, nThreads, keepAliveTime, unit, workQueue, new NamedThreadFactory(name), handler);
    }

    public static ExecutorService newFixedThreadPool(int nThreads, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        return new LoggingExecutor(nThreads, nThreads, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    public static ExecutorService newSingleThreadExecutor(String name) {
        return new FinalizableDelegatedExecutorService(Executors.newFixedThreadPool(1, name));
    }

    public static ExecutorService newSingleThreadExecutor(String name, long keepAliveTime, TimeUnit unit) {
        return new FinalizableDelegatedExecutorService(Executors.newFixedThreadPool(1, name, keepAliveTime, unit));
    }

    public static ExecutorService newSingleThreadExecutor(String name, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        return new FinalizableDelegatedExecutorService(Executors.newFixedThreadPool(1, name, keepAliveTime, unit, workQueue));
    }

    public static ExecutorService newSingleThreadExecutor(long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        return new FinalizableDelegatedExecutorService(Executors.newFixedThreadPool(1, keepAliveTime, unit, workQueue, threadFactory));
    }

    public static ExecutorService newSingleThreadExecutor(String name, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        return new FinalizableDelegatedExecutorService(Executors.newFixedThreadPool(1, name, keepAliveTime, unit, workQueue, handler));
    }

    public static ExecutorService newSingleThreadExecutor(long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        return new FinalizableDelegatedExecutorService(Executors.newFixedThreadPool(1, keepAliveTime, unit, workQueue, threadFactory, handler));
    }

    public static ExecutorService newCachedThreadPool(String name) {
        return new LoggingExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new NamedThreadFactory(name));
    }

    public static ExecutorService newCachedThreadPool(int minThreads, int maxThreads, String name) {
        return new LoggingExecutor(minThreads, maxThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new NamedThreadFactory(name));
    }

    public static ExecutorService newCachedThreadPool(int minThreads, int maxThreads, String name, long keepAliveTime, TimeUnit unit) {
        return new LoggingExecutor(minThreads, maxThreads, keepAliveTime, unit, new SynchronousQueue<Runnable>(), new NamedThreadFactory(name));
    }

    public static ExecutorService newCachedThreadPool(int minThreads, int maxThreads, String name, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        return new LoggingExecutor(minThreads, maxThreads, keepAliveTime, unit, workQueue, new NamedThreadFactory(name));
    }

    public static ExecutorService newCachedThreadPool(int minThreads, int maxThreads, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        return new LoggingExecutor(minThreads, maxThreads, keepAliveTime, unit, workQueue, threadFactory);
    }

    public static ExecutorService newCachedThreadPool(int minThreads, int maxThreads, String name, long keepAliveTime, TimeUnit unit, RejectedExecutionHandler handler) {
        return new LoggingExecutor(minThreads, maxThreads, keepAliveTime, unit, new SynchronousQueue<Runnable>(), new NamedThreadFactory(name), handler);
    }

    public static ExecutorService newCachedThreadPool(int minThreads, int maxThreads, String name, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        return new LoggingExecutor(minThreads, maxThreads, keepAliveTime, unit, workQueue, new NamedThreadFactory(name), handler);
    }

    public static ExecutorService newCachedThreadPool(int minThreads, int maxThreads, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        return new LoggingExecutor(minThreads, maxThreads, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String name) {
        return new DelegatedScheduledExecutorService(new FailsafeScheduledExecutor(name));
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory) {
        return new DelegatedScheduledExecutorService(new FailsafeScheduledExecutor(1, threadFactory));
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String name, RejectedExecutionHandler handler) {
        return new DelegatedScheduledExecutorService(new FailsafeScheduledExecutor(1, name, handler));
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        return new DelegatedScheduledExecutorService(new FailsafeScheduledExecutor(1, threadFactory, handler));
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, String name) {
        return new FailsafeScheduledExecutor(corePoolSize, name);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory) {
        return new FailsafeScheduledExecutor(corePoolSize, threadFactory);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, String name, RejectedExecutionHandler handler) {
        return new FailsafeScheduledExecutor(corePoolSize, name, handler);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        return new FailsafeScheduledExecutor(corePoolSize, threadFactory, handler);
    }

    private Executors() {
    }

    private static class DelegatedScheduledExecutorService
    extends DelegatedExecutorService
    implements ScheduledExecutorService {
        private final ScheduledExecutorService e;

        DelegatedScheduledExecutorService(ScheduledExecutorService executor) {
            super(executor);
            this.e = executor;
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return this.e.schedule(command, delay, unit);
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return this.e.schedule(callable, delay, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return this.e.scheduleAtFixedRate(command, initialDelay, period, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.e.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }
    }

    private static class FinalizableDelegatedExecutorService
    extends DelegatedExecutorService {
        FinalizableDelegatedExecutorService(ExecutorService executor) {
            super(executor);
        }

        protected void finalize() throws Throwable {
            super.shutdown();
            super.finalize();
        }
    }

    private static class DelegatedExecutorService
    extends AbstractExecutorService {
        private final ExecutorService e;

        DelegatedExecutorService(ExecutorService executor) {
            this.e = executor;
        }

        @Override
        public void execute(Runnable command) {
            this.e.execute(command);
        }

        @Override
        public void shutdown() {
            this.e.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.e.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.e.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.e.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.e.awaitTermination(timeout, unit);
        }

        @Override
        public Future<?> submit(Runnable task) {
            return this.e.submit(task);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return this.e.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return this.e.submit(task, result);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.e.invokeAll(tasks);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.e.invokeAll(tasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.e.invokeAny(tasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.e.invokeAny(tasks, timeout, unit);
        }
    }
}

