/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.concurrent;

import java.util.concurrent.Callable;
import org.slf4j.Logger;

class WrappedCallable<T>
implements Callable<T> {
    private final Logger log;
    private final Callable<T> callable;

    private WrappedCallable(Logger log, Callable<T> callable) {
        this.log = log;
        this.callable = callable;
    }

    public static <T> Callable<T> wrap(Logger log, Callable<T> callable) {
        return callable instanceof WrappedCallable ? callable : new WrappedCallable<T>(log, callable);
    }

    @Override
    public T call() throws Exception {
        Thread currentThread = Thread.currentThread();
        try {
            T t = this.callable.call();
            return t;
        }
        catch (Exception e) {
            this.log.debug(currentThread + " ended with an exception", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            this.log.error(currentThread + " ended with an exception", (Throwable)e);
            throw e;
        }
        finally {
            this.log.debug("{} finished executing", (Object)currentThread);
        }
    }
}

